/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper;

import com.atlassian.crowd.integration.directory.connector.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.integration.model.Tombstone;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;

public class TombstoneContextMapper
implements ContextMapper {
    private final ObjectGUIDMapper objectGUIDMapper = new ObjectGUIDMapper();
    private final USNChangedMapper usnChangedMapper = new USNChangedMapper();

    public Object mapFromContext(Object ctx) {
        try {
            DirContextAdapter context = (DirContextAdapter)ctx;
            String guid = this.objectGUIDMapper.getValues(context).get(0);
            String usnChanged = this.usnChangedMapper.getValues(context).get(0);
            return new Tombstone(guid, usnChanged);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve objectGUID/uSNChanged from object: " + ((DirContextAdapter)ctx).getDn());
        }
    }
}

