/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.entity.LDAPGroupAttributesMapper;
import com.atlassian.crowd.integration.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.util.connector.DNStandardiser;
import java.util.List;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupContextMapper
implements ContextMapper {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected final long directoryId;
    protected final GroupType groupType;
    protected final LDAPPropertiesMapper ldapPropertiesMapper;
    protected final List<AttributeMapper> customAttributeMappers;

    public GroupContextMapper(long directoryId, GroupType groupType, LDAPPropertiesMapper ldapPropertiesMapper, List<AttributeMapper> customAttributeMappers) {
        this.directoryId = directoryId;
        this.groupType = groupType;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
        this.customAttributeMappers = customAttributeMappers;
    }

    public Object mapFromContext(Object ctx) throws NamingException {
        DirContextAdapter context = (DirContextAdapter)ctx;
        Attributes attributes = context.getAttributes();
        LDAPGroupAttributesMapper mapper = this.getAttributesMapper();
        GroupTemplateWithAttributes groupTemplate = mapper.mapGroupFromAttributes(attributes);
        for (AttributeMapper attributeMapper : this.customAttributeMappers) {
            try {
                groupTemplate.setAttribute(attributeMapper.getKey(), attributeMapper.getValues(context));
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to map attribute <" + attributeMapper.getKey() + "> from context with DN <" + context.getDn().toString() + ">"));
            }
        }
        String dn = DNStandardiser.standardise((DistinguishedName)context.getDn(), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        LDAPGroupWithAttributes group = new LDAPGroupWithAttributes(dn, groupTemplate);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created group <" + group + "> from DN <" + context.getDn() + ">"));
        }
        return group;
    }

    protected LDAPGroupAttributesMapper getAttributesMapper() {
        return new LDAPGroupAttributesMapper(this.directoryId, this.groupType, this.ldapPropertiesMapper);
    }
}

