/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;

public class EntityContextMapper
implements ContextMapper {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ContextMapper principalContextMapper;
    private final ContextMapper groupContextMapper;
    private final ContextMapper roleContextMapper;
    private final DistinguishedName principalDN;
    private final DistinguishedName groupDN;
    private final DistinguishedName roleDN;
    private final LDAPPropertiesMapper ldapPropertiesMapper;

    public EntityContextMapper(LDAPPropertiesMapper ldapPropertiesMapper, ContextMapper principalContextMapper, ContextMapper groupContextMapper, ContextMapper roleContextMapper, DistinguishedName principalDN, DistinguishedName groupDN, DistinguishedName roleDN) {
        this.ldapPropertiesMapper = ldapPropertiesMapper;
        this.principalContextMapper = principalContextMapper;
        this.groupContextMapper = groupContextMapper;
        this.roleContextMapper = roleContextMapper;
        this.principalDN = principalDN;
        this.groupDN = groupDN;
        this.roleDN = roleDN;
    }

    public Object mapFromContext(Object ctx) {
        DirContextAdapter context = (DirContextAdapter)ctx;
        if (this.isPrincipal(context)) {
            return this.principalContextMapper.mapFromContext((Object)context);
        }
        if (this.isGroup(context)) {
            return this.groupContextMapper.mapFromContext((Object)context);
        }
        if (this.isRole(context)) {
            return this.roleContextMapper.mapFromContext((Object)context);
        }
        return null;
    }

    protected boolean isPrincipal(DirContextAdapter ctx) {
        return this.isOfObjectClass(ctx, this.ldapPropertiesMapper.getUserObjectClass()) && this.isInSubtreeScope(ctx, this.principalDN);
    }

    protected boolean isGroup(DirContextAdapter ctx) {
        return this.isOfObjectClass(ctx, this.ldapPropertiesMapper.getGroupObjectClass()) && this.isInSubtreeScope(ctx, this.groupDN);
    }

    protected boolean isRole(DirContextAdapter ctx) {
        return this.isOfObjectClass(ctx, this.ldapPropertiesMapper.getRoleObjectClass()) && this.isInSubtreeScope(ctx, this.roleDN);
    }

    protected boolean isOfObjectClass(DirContextAdapter ctx, String objectClassToMatch) {
        String objectClassName = this.ldapPropertiesMapper.getObjectClassAttribute();
        try {
            Attribute objectClassAttr;
            Attributes attributes = ctx.getAttributes();
            if (attributes != null && (objectClassAttr = attributes.get(objectClassName)) != null) {
                NamingEnumeration<?> objectClasses = objectClassAttr.getAll();
                while (objectClasses.hasMore()) {
                    Object objectClass = objectClasses.next();
                    if (objectClass == null || !objectClassToMatch.equalsIgnoreCase((String)objectClass)) continue;
                    return true;
                }
            }
        }
        catch (NamingException e) {
            this.logger.warn((Object)("Unable to determine class type of " + ctx.getDn() + "."), (Throwable)e);
        }
        return false;
    }

    protected boolean isInSubtreeScope(DirContextAdapter ctx, DistinguishedName baseDN) {
        return ctx.getDn().startsWith((Name)baseDN);
    }
}

