/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.directory.connector.RFC4519Directory;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.spring.container.ContainerManager;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;

public class OpenLDAP
extends RFC4519Directory {
    public static String getStaticDirectoryType() {
        return "OpenLDAP";
    }

    public String getDescriptiveName() {
        return OpenLDAP.getStaticDirectoryType();
    }

    protected String encodePassword(String unencodedPassword) {
        if (unencodedPassword == null) {
            return null;
        }
        String encryptionAlgorithm = this.ldapPropertiesMapper.getUserEncryptionMethod();
        if (!StringUtils.isBlank((String)encryptionAlgorithm)) {
            PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
            PasswordEncoder passwordEncoder = passwordEncoderFactory.getLdapEncoder(encryptionAlgorithm);
            return passwordEncoder.encodePassword(unencodedPassword, null);
        }
        return unencodedPassword;
    }

    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, user.getName());
    }
}

