/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.directory.connector.RFC4519Directory;
import com.atlassian.crowd.integration.directory.connector.control.DeletedResultsControl;
import com.atlassian.crowd.integration.directory.connector.mapper.TombstoneContextMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.group.RFC4519MemberDnRangeMapper;
import com.atlassian.crowd.integration.directory.connector.name.ActiveDirectoryEncoder;
import com.atlassian.crowd.integration.directory.connector.name.Encoder;
import com.atlassian.crowd.integration.directory.monitor.DirectoryMonitorCreationException;
import com.atlassian.crowd.integration.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.integration.directory.monitor.poller.PollingCapable;
import com.atlassian.crowd.integration.directory.monitor.poller.USNChangedPoller;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.model.Tombstone;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.GreaterThanOrEqualsFilter;
import org.springframework.ldap.filter.HardcodedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrosoftActiveDirectory
extends RFC4519Directory
implements PollingCapable {
    private static final String PRINCIPAL_NO_SSL_CONNECTION = "Secure SSL connections for this directory are not configured; unable to perform this operation.";
    private static final int UF_ACCOUNTDISABLE = 2;
    private static final int UF_PASSWD_NOTREQD = 32;
    private static final int UF_PASSWD_CANT_CHANGE = 64;
    private static final int UF_NORMAL_ACCOUNT = 512;
    private static final int UF_DONT_EXPIRE_PASSWD = 65536;
    private static final int UF_PASSWORD_EXPIRED = 0x800000;
    private static final String AD_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String AD_SAM_ACCOUNT_NAME = "samAccountName";
    private static final String AD_PASSWORD_ENCODED = "UTF-16LE";
    private static final String AD_MEMBEROF = "memberOf";
    private static final String AD_HIGHEST_COMMITTED_USN = "highestCommittedUSN";
    private static final String AD_IS_DELETED = "isDeleted";
    private static final String AD_OBJECT_CLASS = "objectClass";
    private static final String DELETED_OBJECTS_DN_ADDITION = "CN=Deleted Objects";
    private static final String ROOT_DOMAIN_NAMING_CONTEXT = "rootDomainNamingContext";
    private static final String GROUP_TYPE_NAME = "groupType";
    private static final String GROUP_TYPE_VALUE = "2";

    public static String getStaticDirectoryType() {
        return "Microsoft Active Directory";
    }

    public String getDescriptiveName() {
        return MicrosoftActiveDirectory.getStaticDirectoryType();
    }

    @Override
    protected Encoder getEncoder() {
        return new ActiveDirectoryEncoder();
    }

    @Override
    protected String getInitialGroupMemberDN() {
        return null;
    }

    @Override
    protected String encodePassword(String unencodedPassword) throws InvalidCredentialException {
        try {
            String newQuotedPassword = "\"" + unencodedPassword + "\"";
            return new String(newQuotedPassword.getBytes(AD_PASSWORD_ENCODED));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCredentialException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        attributes.put(AD_SAM_ACCOUNT_NAME, user.getName());
        String accountStatus = null;
        accountStatus = user.isActive() ? Integer.toString(0x800220) : Integer.toString(0x800222);
        attributes.put(new BasicAttribute(AD_USER_ACCOUNT_CONTROL, accountStatus));
    }

    @Override
    protected void getNewGroupDirectorySpecificAttributes(Group group, Attributes attributes) {
        attributes.put(GROUP_TYPE_NAME, GROUP_TYPE_VALUE);
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomUserAttributeMappers();
        mappers.add(new ObjectGUIDMapper());
        mappers.add(new USNChangedMapper());
        return mappers;
    }

    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomGroupAttributeMappers();
        mappers.add(new ObjectGUIDMapper());
        mappers.add(new USNChangedMapper());
        return mappers;
    }

    @Override
    protected AttributeMapper getMemberDnMapper() {
        return new RFC4519MemberDnRangeMapper(this.ldapTemplate, this.ldapPropertiesMapper.getGroupMemberAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation());
    }

    @Override
    protected Hashtable<String, String> getBaseEnvironmentProperties() {
        Hashtable<String, String> env = super.getBaseEnvironmentProperties();
        env.put("java.naming.ldap.attributes.binary", "objectGUID");
        return env;
    }

    public long fetchHighestCommittedUSN() {
        try {
            Attribute highestCommittedUSN = ((DirContextAdapter)this.ldapTemplate.lookup("")).getAttributes().get(AD_HIGHEST_COMMITTED_USN);
            long usn = Long.parseLong((String)highestCommittedUSN.get(0));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Fetched highest committed uSN of " + usn));
            }
            return usn;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving highestCommittedUSN from AD root", (Throwable)e);
            throw new UnsupportedOperationException("Error retrieving highestCommittedUSN from AD root", e);
        }
    }

    public List<LDAPUserWithAttributes> findAddedOrUpdatedUsersSince(long usnChange) {
        return this.findAddedOrUpdatedObjectsSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserFilter(), this.getUserContextMapper());
    }

    public List<LDAPGroupWithAttributes> findAddedOrUpdatedGroupsSince(long usnChanged) {
        return this.findAddedOrUpdatedObjectsSince(usnChanged, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP));
    }

    public List<Tombstone> findUserTombstonesSince(long usnChange) {
        return this.findTombstonesSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserObjectClass());
    }

    public List<Tombstone> findGroupTombstonesSince(long usnChange) {
        return this.findTombstonesSince(usnChange, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupObjectClass());
    }

    protected List findAddedOrUpdatedObjectsSince(long usnChange, Name objectBaseDN, String objectFilter, ContextMapper contextMapper) {
        AndFilter filter = new AndFilter();
        filter.and((Filter)new HardcodedFilter(objectFilter));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        this.logger.debug((Object)("Performing polling search: baseDN = " + objectBaseDN + " - filter = " + filter.encode()));
        return this.searchEntities(objectBaseDN, filter.encode(), contextMapper, 0, -1);
    }

    private Name getDeletedObjectsDN() {
        try {
            DirContextAdapter root = (DirContextAdapter)this.ldapTemplate.lookup("");
            String rootDN = root.getStringAttribute(ROOT_DOMAIN_NAMING_CONTEXT);
            String dn = new StringBuffer(DELETED_OBJECTS_DN_ADDITION).append(",").append(rootDN).toString();
            return new CompositeName(dn);
        }
        catch (NamingException e) {
            return this.searchDN.getNamingContext();
        }
    }

    protected List<Tombstone> findTombstonesSince(long usnChange, Name objectBaseDN, String objectClass) {
        SearchControls searchControls = this.getSubTreeSearchControl();
        searchControls.setReturningAttributes(new String[]{"objectGUID", "uSNChanged"});
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter(AD_IS_DELETED, "TRUE"));
        filter.and((Filter)new EqualsFilter(AD_OBJECT_CLASS, objectClass));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        Name deletedObjectsDN = this.getDeletedObjectsDN();
        this.logger.debug((Object)("Performing tombstones search: baseDN = " + deletedObjectsDN + " - filter = " + filter.encode()));
        TombstoneContextMapper contextMapper = new TombstoneContextMapper();
        return this.searchEntitiesWithRequestControls(deletedObjectsDN, filter.encode(), contextMapper, searchControls, (DirContextProcessor)new DeletedResultsControl(), 0, -1);
    }

    public DirectoryPoller getDirectoryMonitor() throws DirectoryMonitorCreationException {
        try {
            return new USNChangedPoller(this, this.eventManager);
        }
        catch (Exception e) {
            throw new DirectoryMonitorCreationException(e.getMessage(), (Throwable)e);
        }
    }
}

