/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.util.connector.LDAPPropertiesHelper;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InvalidNameException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPropertiesMapperImpl
implements LDAPPropertiesMapper {
    private static final Logger logger = Logger.getLogger(LDAPPropertiesMapperImpl.class);
    private Map<String, String> attributes;
    private LDAPPropertiesHelper ldapPropertiesHelper;
    public static final String CONNECTION_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String CONNECTION_SECURITY_AUTHENTICATION = "simple";
    public static final String CONNECTION_SSL_SECURITY_PROTOCOL = "ssl";
    public static final String CONNECTION_FACTORY = "java.naming.ldap.factory.socket";
    public static final String CONNECTION_FACTORY_SSL_IMPL = "javax.net.ssl.SSLSocketFactory";
    public static final String CONNECTION_BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";

    public Map<String, String> getImplementations() {
        return this.getLdapPropertiesHelper().getImplementations();
    }

    public Map<String, Properties> getConfigurationDetails() {
        return this.getLdapPropertiesHelper().getConfigurationDetails();
    }

    public Hashtable<String, String> getEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", CONNECTION_INITIAL_CONTEXT_FACTORY);
        environment.put("java.naming.security.authentication", CONNECTION_SECURITY_AUTHENTICATION);
        if (this.isReferral()) {
            environment.put("java.naming.referral", "follow");
        }
        if (this.isSecureSSL()) {
            environment.put("java.naming.security.protocol", CONNECTION_SSL_SECURITY_PROTOCOL);
            environment.put(CONNECTION_FACTORY, CONNECTION_FACTORY_SSL_IMPL);
        }
        if (this.isUsingConnectionPooling()) {
            environment.put("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            environment.put("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        }
        return environment;
    }

    protected boolean isSecureSSL() {
        return this.getBooleanKey("ldap.secure");
    }

    protected boolean isReferral() {
        return this.getBooleanKey("ldap.referral");
    }

    protected boolean isUsingConnectionPooling() {
        return this.getBooleanKey("ldap.pooling");
    }

    protected boolean getBooleanKey(String key) {
        return this.getBooleanKey(key, false);
    }

    protected boolean getBooleanKey(String key, boolean defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        return value == null ? "" : value;
    }

    public String getBaseDN() throws InvalidNameException {
        return this.getAttribute("ldap.basedn");
    }

    public String getGroupBaseDN() throws InvalidNameException {
        String additionalDN = this.getAttribute("ldap.group.dn");
        String groupSearchDN = additionalDN != null && !additionalDN.equals("") ? additionalDN + "," + this.getAttribute("ldap.basedn") : this.getAttribute("ldap.basedn");
        return groupSearchDN;
    }

    public String getGroupFilter() {
        return this.getAttribute("ldap.group.filter");
    }

    public String getConnectionURL() {
        return this.getAttribute("ldap.url");
    }

    public String getUsername() {
        return this.getAttribute("ldap.userdn");
    }

    public String getPassword() {
        return this.getAttribute("ldap.password");
    }

    public String getGroupNameAttribute() {
        return this.getAttribute("ldap.group.name");
    }

    public String getObjectClassAttribute() {
        return "objectClass";
    }

    public String getRoleFilter() {
        return this.getAttribute("ldap.role.filter");
    }

    public String getRoleBaseDN() throws InvalidNameException {
        String additionalDN = this.getAttribute("ldap.role.dn");
        String roleSearchDN = additionalDN != null && !additionalDN.equals("") ? additionalDN + "," + this.getAttribute("ldap.basedn") : this.getAttribute("ldap.basedn");
        return roleSearchDN;
    }

    public String getRoleNameAttribute() {
        return this.getAttribute("ldap.role.name");
    }

    public String getUserFilter() {
        return this.getAttribute("ldap.user.filter");
    }

    public String getPrincipalBaseDN() {
        String additionalDN = this.getAttribute("ldap.user.dn");
        String principalSearchDN = additionalDN != null && !additionalDN.equals("") ? additionalDN + "," + this.getAttribute("ldap.basedn") : this.getAttribute("ldap.basedn");
        return principalSearchDN;
    }

    public String getUserNameAttribute() {
        return this.getAttribute("ldap.user.username");
    }

    public String getUserNameRdnAttribute() {
        return this.getAttribute("ldap.user.username.rdn");
    }

    public String getUserEmailAttribute() {
        return this.getAttribute("ldap.user.email");
    }

    public String getUserGroupMembershipsAttribute() {
        return this.getAttribute("ldap.user.group");
    }

    public String getGroupObjectClass() {
        return this.getAttribute("ldap.group.objectclass");
    }

    public String getGroupDescriptionAttribute() {
        return this.getAttribute("ldap.group.description");
    }

    public String getGroupMemberAttribute() {
        return this.getAttribute("ldap.group.usernames");
    }

    public String getRoleObjectClass() {
        return this.getAttribute("ldap.role.objectclass");
    }

    public String getRoleDescriptionAttribute() {
        return this.getAttribute("ldap.role.description");
    }

    public String getRoleMemberAttribute() {
        return this.getAttribute("ldap.role.usernames");
    }

    public String getUserObjectClass() {
        return this.getAttribute("ldap.user.objectclass");
    }

    public String getUserFirstNameAttribute() {
        return this.getAttribute("ldap.user.firstname");
    }

    public String getUserLastNameAttribute() {
        return this.getAttribute("ldap.user.lastname");
    }

    public String getUserDisplayNameAttribute() {
        return this.getAttribute("ldap.user.displayname");
    }

    public String getUserPasswordAttribute() {
        return this.getAttribute("ldap.user.password");
    }

    public String getUserEncryptionMethod() {
        return this.getAttribute("ldap.user.encryption");
    }

    public boolean isPagedResultsControl() {
        boolean isPagedResultsControl = false;
        String isPagedResultsControlStr = this.getAttribute("ldap.pagedresults");
        if (isPagedResultsControlStr != null) {
            isPagedResultsControl = Boolean.valueOf(isPagedResultsControlStr);
        }
        return isPagedResultsControl;
    }

    public int getPagedResultsSize() {
        int pagedResultsControlSize = 999;
        String isPagedResultsControlSizeStr = this.getAttribute("ldap.pagedresults.size");
        if (isPagedResultsControlSizeStr != null) {
            pagedResultsControlSize = Integer.valueOf(isPagedResultsControlSizeStr);
        }
        return pagedResultsControlSize;
    }

    public boolean isNestedGroupsDisabled() {
        return this.getBooleanKey("ldap.nestedgroups.disabled", true);
    }

    public boolean isUsingUserMembershipAttribute() {
        return this.getBooleanKey("ldap.usermembership.use");
    }

    public boolean isUsingUserMembershipAttributeForGroupMembership() {
        return this.getBooleanKey("ldap.usermembership.use.for.groups");
    }

    public boolean isRelaxedDnStandardisation() {
        return this.getBooleanKey("ldap.relaxed.dn.standardisation");
    }

    public boolean isRolesDisabled() {
        return this.getBooleanKey("ldap.roles.disabled");
    }

    public LDAPPropertiesHelper getLdapPropertiesHelper() {
        return this.ldapPropertiesHelper;
    }

    public void setLdapPropertiesHelper(LDAPPropertiesHelper ldapPropertiesHelper) {
        this.ldapPropertiesHelper = ldapPropertiesHelper;
    }
}

