/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.directory.connector.ApacheDS;
import com.atlassian.crowd.integration.directory.monitor.DirectoryMonitorCreationException;
import com.atlassian.crowd.integration.directory.monitor.listener.ApacheDSPersistentSearchListener;
import com.atlassian.crowd.integration.directory.monitor.listener.ChangeListener;
import com.atlassian.crowd.integration.directory.monitor.listener.DirectoryListener;
import com.atlassian.crowd.integration.directory.monitor.listener.ListeningCapable;
import com.atlassian.crowd.integration.model.user.User;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

public class ApacheDS15
extends ApacheDS
implements ListeningCapable {
    public static String getStaticDirectoryType() {
        return "Apache Directory Server 1.5.x";
    }

    public String getDescriptiveName() {
        return ApacheDS15.getStaticDirectoryType();
    }

    protected String getInitialGroupMemberDN() {
        return this.ldapPropertiesMapper.getUsername();
    }

    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        if (StringUtils.isBlank((String)user.getLastName())) {
            this.addDefaultSnToUserAttributes(attributes, " ");
        }
        if (StringUtils.isBlank((String)user.getEmailAddress())) {
            this.addDefaultValueToUserAttributesForAttribute(this.ldapPropertiesMapper.getUserEmailAttribute(), attributes, " ");
        }
    }

    protected LdapTemplate createChangeListenerTemplate() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapPropertiesMapper.getConnectionURL());
        contextSource.setUserDn(this.ldapPropertiesMapper.getUsername());
        contextSource.setPassword(this.ldapPropertiesMapper.getPassword());
        contextSource.setBaseEnvironmentProperties(this.getBaseEnvironmentProperties());
        contextSource.setPooled(true);
        contextSource.setDirObjectFactory(null);
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        return new LdapTemplate((ContextSource)contextSource);
    }

    public void addChangeListener(final ChangeListener changeListener) {
        final SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        ContextExecutor contextExecutor = new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                EventDirContext ectx = (EventDirContext)ctx.lookup("");
                ectx.addNamingListener(changeListener.getBaseDN(), changeListener.getObjectFilter(), searchControls, (NamingListener)changeListener);
                return null;
            }
        };
        this.createChangeListenerTemplate().executeReadOnly(contextExecutor);
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        ContextExecutor contextExecutor = new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                EventDirContext ectx = (EventDirContext)ctx.lookup("");
                ectx.removeNamingListener(changeListener);
                return null;
            }
        };
        this.createChangeListenerTemplate().executeReadOnly(contextExecutor);
    }

    public DirectoryListener getDirectoryMonitor() throws DirectoryMonitorCreationException {
        return new ApacheDSPersistentSearchListener(this, this.eventManager);
    }
}

