/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.cache;

import com.atlassian.crowd.integration.directory.cache.DefaultDirectoryCache;
import com.atlassian.crowd.integration.directory.cache.model.EntityIdentifier;
import com.atlassian.crowd.integration.directory.cache.model.EntityType;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.util.Assert;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class LDAPDirectoryCache
extends DefaultDirectoryCache {
    private static final String DN_TO_ENTITY_IDENTIFIER_CACHE = "com.atlassian.crowd.integration.directory.caching-dn-identifier";
    private static final String ENTITY_IDENTIFIER_TO_DN_CACHE = "com.atlassian.crowd.integration.directory.caching-identifier-dn";
    protected final Cache dnToEntityIdentifierCache = this.createAndConfigureCache("com.atlassian.crowd.integration.directory.caching-dn-identifier");
    protected final Cache entityIdentifierToDnCache = this.createAndConfigureCache("com.atlassian.crowd.integration.directory.caching-identifier-dn");

    public LDAPDirectoryCache(long directoryID, CacheManager ehcacheManager, int maxElementsInMemoryPerSubCache) {
        super(directoryID, ehcacheManager, maxElementsInMemoryPerSubCache);
    }

    protected void doClear() {
        super.doClear();
        this.dnToEntityIdentifierCache.removeAll();
        this.entityIdentifierToDnCache.removeAll();
    }

    protected void doClose() {
        super.doClose();
        this.removeCache(DN_TO_ENTITY_IDENTIFIER_CACHE);
        this.removeCache(ENTITY_IDENTIFIER_TO_DN_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUser(User user) {
        this.lockWrite();
        try {
            this.storeEntity((DirectoryEntity)user, this.userCache, this.userNamesCache);
            this.storeDnMapping((DirectoryEntity)user);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGroup(Group group) {
        this.lockWrite();
        try {
            this.storeEntity((DirectoryEntity)group, this.groupCache, this.groupNamesCache);
            this.storeDnMapping((DirectoryEntity)group);
            this.updateGroupMembersFromMemberDNs(group);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userName) {
        this.lockWrite();
        try {
            super.removeUser(userName);
            this.removeDnMapping(EntityType.USER, userName);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String groupName) {
        this.lockWrite();
        try {
            super.removeGroup(groupName);
            this.removeDnMapping(EntityType.GROUP, groupName);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String userName) throws ObjectNotFoundException {
        this.lockRead();
        try {
            User user = (User)this.getEntity(userName, this.userCache);
            return user;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupName) throws ObjectNotFoundException {
        this.lockRead();
        try {
            Group group = (Group)this.getEntity(groupName, this.groupCache);
            return group;
        }
        finally {
            this.unlockRead();
        }
    }

    protected void storeDnMapping(DirectoryEntity entity) {
        EntityIdentifier identifier;
        if (entity instanceof LDAPUserWithAttributes) {
            identifier = new EntityIdentifier(EntityType.USER, entity.getName());
        } else if (entity instanceof LDAPGroupWithAttributes) {
            identifier = new EntityIdentifier(EntityType.GROUP, entity.getName());
        } else {
            throw new IllegalArgumentException("DirectoryEntity must be instance of LDAPUserWithAttributes or LDAPGroupWithAttributes, not: " + entity.getClass().getCanonicalName());
        }
        String dn = this.getDn(entity);
        Assert.notNull((Object)dn, (String)"DN attribute cannot be null");
        this.dnToEntityIdentifierCache.put(new Element((Serializable)((Object)dn), (Serializable)identifier));
        this.entityIdentifierToDnCache.put(new Element((Serializable)identifier, (Serializable)((Object)dn)));
    }

    protected String getDn(DirectoryEntity directoryEntity) {
        if (directoryEntity instanceof LDAPDirectoryEntity) {
            return ((LDAPDirectoryEntity)directoryEntity).getDn();
        }
        throw new IllegalArgumentException("Cannot retrieve DN from DirectoryEntity: " + directoryEntity);
    }

    protected void removeDnMapping(EntityType type, String name) {
        EntityIdentifier identifier = new EntityIdentifier(type, name);
        String dn = this.getDnForEntityIdentifier(identifier);
        if (dn != null) {
            this.removeDnMapping(dn);
        }
    }

    public void removeDnMapping(String dn) {
        try {
            EntityIdentifier identifier = this.getEntityIdentifierForDn(dn);
            if (identifier != null) {
                this.entityIdentifierToDnCache.remove((Serializable)identifier);
            }
            this.dnToEntityIdentifierCache.put(new Element((Serializable)((Object)dn), (Serializable)Boolean.valueOf(false)));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdentifier getEntityIdentifierForDn(String dn) throws ObjectNotFoundException {
        this.lockRead();
        try {
            Object identifier = this.getFromCache((Serializable)((Object)dn), this.dnToEntityIdentifierCache);
            if (identifier != null && identifier instanceof Boolean && !((Boolean)identifier).booleanValue()) {
                throw new ObjectNotFoundException(DirectoryEntity.class, (Object)dn);
            }
            EntityIdentifier entityIdentifier = (EntityIdentifier)identifier;
            return entityIdentifier;
        }
        finally {
            this.unlockRead();
        }
    }

    protected String getDnForEntityIdentifier(EntityIdentifier identifier) {
        return (String)this.getFromCache(identifier, this.entityIdentifierToDnCache);
    }

    protected void updateGroupMembersFromMemberDNs(Group group) {
        boolean atLeastOneUncachedMember;
        HashSet<String> newGroupNames;
        HashSet<String> newUserNames;
        if (group instanceof LDAPGroupWithAttributes) {
            LDAPGroupWithAttributes ldapGroup = (LDAPGroupWithAttributes)group;
            List memberDNs = ldapGroup.getAttributes("memberDNs");
            if (memberDNs == null) {
                throw new IllegalArgumentException("Cannot cache LDAPGroupWithAttributes that does not have an RFC4519 compliant memberDNs attribute: " + group);
            }
            newUserNames = new HashSet<String>();
            newGroupNames = new HashSet<String>();
            atLeastOneUncachedMember = false;
            for (String memberDN : memberDNs) {
                try {
                    EntityIdentifier member = this.getEntityIdentifierForDn(memberDN);
                    if (member != null) {
                        if (member.getType() == EntityType.USER) {
                            newUserNames.add(member.getName());
                            continue;
                        }
                        if (member.getType() != EntityType.GROUP) continue;
                        newGroupNames.add(member.getName());
                        continue;
                    }
                    atLeastOneUncachedMember = true;
                }
                catch (ObjectNotFoundException e) {}
            }
        } else {
            throw new IllegalArgumentException("Group must be of class LDAPGroupWithAttributes, not: " + group.getClass().getCanonicalName());
        }
        boolean complete = !atLeastOneUncachedMember;
        this.storeUserMembersOfGroup(group.getName(), newUserNames, complete);
        this.storeGroupMembersOfGroup(group.getName(), newGroupNames, complete);
    }
}

