/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.cache;

import com.atlassian.crowd.event.remote.RemoteDirectoryEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupCreatedOrUpdatedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupDeletedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserCreatedOrUpdatedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserDeletedEvent;
import com.atlassian.crowd.integration.directory.cache.DirectoryCache;
import com.atlassian.crowd.integration.directory.cache.DirectoryCacheStatistics;
import com.atlassian.crowd.integration.directory.cache.model.DualNameKey;
import com.atlassian.crowd.integration.directory.cache.model.PartialSet;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.util.Assert;
import com.atlassian.event.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryCache
implements DirectoryCache {
    private static final String ALL_NAMES_KEY = "all.names.key";
    private static final String PRINCIPAL_CACHE = "com.atlassian.crowd.integration.directory.caching-users";
    private static final String GROUP_CACHE = "com.atlassian.crowd.integration.directory.caching-groups";
    private static final String PRINCIPAL_NAMES_CACHE = "com.atlassian.crowd.integration.directory.caching-user-names";
    private static final String GROUP_NAMES_CACHE = "com.atlassian.crowd.integration.directory.caching-group-names";
    private static final String PRINCIPAL_GROUPS_CACHE = "com.atlassian.crowd.integration.directory.caching-user-groups";
    private static final String GROUP_PRINCIPALS_CACHE = "com.atlassian.crowd.integration.directory.caching-group-users";
    private static final String GROUP_PARENTGROUPS_CACHE = "com.atlassian.crowd.integration.directory.caching-group-parentgroups";
    private static final String GROUP_CHILDGROUPS_CACHE = "com.atlassian.crowd.integration.directory.caching-group-childgroups";
    private static final String PRINCIPAL_GROUP_MEMBERSHIP_EXISTS_CACHE = "com.atlassian.crowd.integration.directory.caching-user-group-member";
    private static final String GROUP_GROUP_MEMBERSHIP_EXISTS_CACHE = "com.atlassian.crowd.integration.directory.caching-group-group-member";
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final long directoryId;
    protected final int maxElementsInMemoryPerSubCache;
    protected final CacheManager cacheManager;
    protected final Cache userCache;
    protected final Cache groupCache;
    protected final Cache userNamesCache;
    protected final Cache groupNamesCache;
    protected final Cache userGroupsCache;
    protected final Cache groupUsersCache;
    protected final Cache groupChildGroupsCache;
    protected final Cache groupParentGroupsCache;
    protected final Cache userGroupMembershipExistsCache;
    protected final Cache groupGroupMembershipExistsCache;
    private final ReadWriteLock readWriteLock;
    private Date lastUpdated;

    public DefaultDirectoryCache(long directoryId, CacheManager ehcacheManager, int maxElementsInMemoryPerSubCache) {
        this.directoryId = directoryId;
        this.cacheManager = ehcacheManager;
        this.maxElementsInMemoryPerSubCache = maxElementsInMemoryPerSubCache;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.userCache = this.createAndConfigureCache(PRINCIPAL_CACHE);
        this.groupCache = this.createAndConfigureCache(GROUP_CACHE);
        this.userNamesCache = this.createAndConfigureCache(PRINCIPAL_NAMES_CACHE);
        this.groupNamesCache = this.createAndConfigureCache(GROUP_NAMES_CACHE);
        this.userGroupsCache = this.createAndConfigureCache(PRINCIPAL_GROUPS_CACHE);
        this.groupUsersCache = this.createAndConfigureCache(GROUP_PRINCIPALS_CACHE);
        this.groupChildGroupsCache = this.createAndConfigureCache(GROUP_CHILDGROUPS_CACHE);
        this.groupParentGroupsCache = this.createAndConfigureCache(GROUP_PARENTGROUPS_CACHE);
        this.userGroupMembershipExistsCache = this.createAndConfigureCache(PRINCIPAL_GROUP_MEMBERSHIP_EXISTS_CACHE);
        this.groupGroupMembershipExistsCache = this.createAndConfigureCache(GROUP_GROUP_MEMBERSHIP_EXISTS_CACHE);
    }

    protected Cache createAndConfigureCache(String cacheName) {
        String uniqueCacheName = new StringBuffer(cacheName).append(this.directoryId).toString();
        Cache cache = new Cache(uniqueCacheName, this.maxElementsInMemoryPerSubCache, true, true, 0L, 0L);
        this.cacheManager.addCache(cache);
        return this.cacheManager.getCache(uniqueCacheName);
    }

    protected void removeCache(String cacheName) {
        String uniqueCacheName = new StringBuffer(cacheName).append(this.directoryId).toString();
        this.cacheManager.removeCache(uniqueCacheName);
    }

    protected void lockRead() {
        this.readWriteLock.readLock().lock();
    }

    protected void unlockRead() {
        this.readWriteLock.readLock().unlock();
    }

    protected void lockWrite() {
        this.readWriteLock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lastUpdated = new Date();
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lockWrite();
        try {
            this.doClear();
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void doClear() {
        this.userCache.removeAll();
        this.groupCache.removeAll();
        this.userNamesCache.removeAll();
        this.groupNamesCache.removeAll();
        this.userGroupsCache.removeAll();
        this.groupUsersCache.removeAll();
        this.groupChildGroupsCache.removeAll();
        this.groupParentGroupsCache.removeAll();
        this.userGroupMembershipExistsCache.removeAll();
        this.groupGroupMembershipExistsCache.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lockWrite();
        try {
            this.doClose();
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void doClose() {
        this.removeCache(PRINCIPAL_CACHE);
        this.removeCache(GROUP_CACHE);
        this.removeCache(PRINCIPAL_NAMES_CACHE);
        this.removeCache(GROUP_NAMES_CACHE);
        this.removeCache(PRINCIPAL_GROUPS_CACHE);
        this.removeCache(GROUP_PRINCIPALS_CACHE);
        this.removeCache(GROUP_CHILDGROUPS_CACHE);
        this.removeCache(GROUP_PARENTGROUPS_CACHE);
        this.removeCache(PRINCIPAL_GROUP_MEMBERSHIP_EXISTS_CACHE);
        this.removeCache(GROUP_GROUP_MEMBERSHIP_EXISTS_CACHE);
    }

    protected String getKey(String name) {
        if (name != null) {
            return name.toLowerCase();
        }
        return name;
    }

    protected Collection<String> getKeys(Collection<String> names) {
        ArrayList<String> keys = new ArrayList<String>(names.size());
        for (String name : names) {
            keys.add(this.getKey(name));
        }
        return keys;
    }

    protected Object getEntity(String name, Cache entityCache) throws ObjectNotFoundException {
        Object entity = this.getFromCache((Serializable)((Object)this.getKey(name)), entityCache);
        if (entity != null && entity instanceof Boolean && !((Boolean)entity).booleanValue()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("About to throw ObjectNotFoundException for " + entity));
            }
            throw new ObjectNotFoundException();
        }
        return entity;
    }

    protected Object getFromCache(Serializable name, Cache cache) {
        Element element = cache.get(name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Fetched element " + element + " for name " + name + " from cache " + cache));
        }
        return element == null ? null : element.getValue();
    }

    protected PartialSet<String> getAllEntityNames(Cache entityNamesCache) {
        Element element = entityNamesCache.get((Serializable)((Object)ALL_NAMES_KEY));
        return element == null ? null : (PartialSet)element.getValue();
    }

    protected List<String> getAllEntityNamesAsList(Cache entityNamesCache) {
        PartialSet<String> names = this.getAllEntityNames(entityNamesCache);
        return names == null || !names.isComplete() ? null : names.asList();
    }

    protected void storeAllEntityNames(List<String> entityNames, Cache entityNamesCache) {
        Assert.notNull(entityNames, (String)"Entity names cannot be null");
        entityNamesCache.put(new Element((Serializable)((Object)ALL_NAMES_KEY), new PartialSet<String>(entityNames, true)));
    }

    protected void storeEntity(DirectoryEntity entity, Cache entityCache, Cache entityNamesCache) {
        Assert.notNull((Object)entity, (String)"DirectoryEntity cannot be null");
        Assert.notNull((Object)entity.getName(), (String)"Name of DirectoryEntity cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Storing name " + entity.getName() + ", value " + entity + " in cache " + entityCache));
        }
        entityCache.put(new Element((Object)this.getKey(entity.getName()), (Object)entity));
        PartialSet<String> names = this.getAllEntityNames(entityNamesCache);
        if (names != null) {
            names.add(entity.getName());
        }
    }

    protected void removeEntity(String entityName, Cache entityCache, Cache entityNamesCache) {
        Assert.notNull((Object)entityName, (String)"Entity name cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing name " + entityName + " from cache " + entityCache));
        }
        entityCache.put(new Element((Serializable)((Object)this.getKey(entityName)), (Serializable)Boolean.valueOf(false)));
        PartialSet<String> names = this.getAllEntityNames(entityNamesCache);
        if (names != null) {
            names.remove(entityName);
        }
    }

    protected void removeAllRelations(String entityName, Cache relationsCache, Cache inverseRelationsCache, Cache booleanMembershipCache, boolean isContainer) {
        Assert.notNull((Object)entityName);
        List<String> relationshipsAsList = this.getRelationshipsAsList(entityName, relationsCache);
        if (relationshipsAsList != null) {
            for (String relationName : relationshipsAsList) {
                this.removeRelationship(relationName, entityName, inverseRelationsCache);
                if (isContainer) {
                    this.setMembershipFlag(relationName, entityName, false, booleanMembershipCache);
                    continue;
                }
                this.setMembershipFlag(entityName, relationName, false, booleanMembershipCache);
            }
            relationsCache.remove((Serializable)((Object)entityName));
        }
    }

    protected PartialSet<String> getRelationships(String entityName, Cache relationshipCache) {
        return (PartialSet)this.getFromCache((Serializable)((Object)this.getKey(entityName)), relationshipCache);
    }

    protected List<String> getRelationshipsAsList(String entityName, Cache relationshipCache) {
        PartialSet<String> relationships = this.getRelationships(entityName, relationshipCache);
        return relationships == null ? null : relationships.asList();
    }

    protected List<String> getCompleteRelationshipsAsList(String entityName, Cache relationshipCache, Cache entityCache) {
        PartialSet<String> relationships = this.getRelationships(entityName, relationshipCache);
        if (relationships == null || !relationships.isComplete()) {
            return null;
        }
        Set<String> relationshipsSet = relationships.getUnderlyingSet();
        ArrayList<String> relationsInCorrectCase = new ArrayList<String>(relationshipsSet.size());
        for (String relation : relationshipsSet) {
            try {
                DirectoryEntity entity = (DirectoryEntity)this.getEntity(relation, entityCache);
                if (entity == null) {
                    return null;
                }
                relationsInCorrectCase.add(entity.getName());
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
        }
        return relationsInCorrectCase;
    }

    protected void removeRelationship(String entityName, String relationName, Cache relationshipCache) {
        Element element = relationshipCache.get((Serializable)((Object)this.getKey(entityName)));
        if (element != null) {
            PartialSet memberships = (PartialSet)element.getValue();
            memberships.remove(this.getKey(relationName));
        }
    }

    protected void addRelationship(String entityName, String relationName, Cache relationshipCache) {
        Element element = relationshipCache.get((Serializable)((Object)this.getKey(entityName)));
        if (element != null) {
            PartialSet memberships = (PartialSet)element.getValue();
            memberships.add(this.getKey(relationName));
        } else {
            relationshipCache.put(new Element((Serializable)((Object)this.getKey(entityName)), new PartialSet<String>(this.getKey(relationName))));
        }
    }

    protected void setMembershipFlag(String memberName, String containerName, boolean membershipFlag, Cache booleanMembershipCache) {
        booleanMembershipCache.put(new Element((Serializable)new DualNameKey(this.getKey(memberName), this.getKey(containerName)), (Serializable)Boolean.valueOf(membershipFlag)));
    }

    protected void removeMembership(String memberName, String containerName, Cache membershipsCache, Cache membersCache, Cache booleanMembershipCache) {
        this.removeRelationship(memberName, containerName, membershipsCache);
        this.removeRelationship(containerName, memberName, membersCache);
        this.setMembershipFlag(memberName, containerName, false, booleanMembershipCache);
    }

    protected void addMembership(String memberName, String containerName, Cache membershipsCache, Cache membersCache, Cache booleanMembershipCache) {
        this.addRelationship(memberName, containerName, membershipsCache);
        this.addRelationship(containerName, memberName, membersCache);
        this.setMembershipFlag(memberName, containerName, true, booleanMembershipCache);
    }

    protected void storeMembers(String containerName, Collection<String> memberNames, Cache membersCache, Cache membershipsCache, Cache booleanMembershipCache, boolean complete) {
        Assert.notNull((Object)containerName, (String)"Container name cannot be null");
        Assert.notNull(memberNames, (String)"Member names cannot be null");
        this.removeAllRelations(this.getKey(containerName), membersCache, membershipsCache, booleanMembershipCache, true);
        membersCache.put(new Element((Serializable)((Object)this.getKey(containerName)), new PartialSet<String>(this.getKeys(memberNames), complete)));
        for (String memberName : memberNames) {
            this.addRelationship(memberName, containerName, membershipsCache);
            this.setMembershipFlag(memberName, containerName, true, booleanMembershipCache);
        }
    }

    protected void storeMemberships(String memberName, Collection<String> membershipNames, Cache membershipsCache, Cache membersCache, Cache booleanMembershipCache) {
        Assert.notNull((Object)memberName, (String)"Member name cannot be null");
        Assert.notNull(membershipNames, (String)"Membership names cannot be null");
        this.removeAllRelations(this.getKey(memberName), membershipsCache, membersCache, booleanMembershipCache, false);
        membershipsCache.put(new Element((Serializable)((Object)this.getKey(memberName)), new PartialSet<String>(this.getKeys(membershipNames), true)));
        for (String containerName : membershipNames) {
            this.addRelationship(containerName, memberName, membersCache);
            this.setMembershipFlag(memberName, containerName, true, booleanMembershipCache);
        }
    }

    protected Boolean isMember(String memberName, String containerName, Cache membershipsCache, Cache membersCache, Cache booleanMembershipCache) {
        Assert.notNull((Object)memberName, (String)"Member name cannot be null");
        Assert.notNull((Object)containerName, (String)"Container name cannot be null");
        memberName = this.getKey(memberName);
        containerName = this.getKey(containerName);
        Element element = booleanMembershipCache.get((Serializable)new DualNameKey(memberName, containerName));
        if (element == null) {
            PartialSet<String> memberships = this.getRelationships(memberName, membershipsCache);
            PartialSet<String> members = this.getRelationships(containerName, membersCache);
            if (memberships != null && memberships.isComplete() && !memberships.contains(containerName) || members != null && members.isComplete() && !members.contains(memberName)) {
                return false;
            }
        }
        return element == null ? null : (Boolean)element.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String userName) throws ObjectNotFoundException {
        this.lockRead();
        try {
            User user = (User)this.getEntity(userName, this.userCache);
            if (user != null) {
                user = new UserTemplate(user);
            }
            User user2 = user;
            return user2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllUserNames() {
        this.lockRead();
        try {
            List<String> list = this.getAllEntityNamesAsList(this.userNamesCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAllUserNames(List<String> userNames) {
        this.lockWrite();
        try {
            this.storeAllEntityNames(userNames, this.userNamesCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUser(User user) {
        this.lockWrite();
        try {
            this.storeEntity((DirectoryEntity)new UserTemplate(user), this.userCache, this.userNamesCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userName) {
        this.lockWrite();
        try {
            this.removeEntity(userName, this.userCache, this.userNamesCache);
            this.removeAllRelations(userName, this.userGroupsCache, this.groupUsersCache, this.userGroupMembershipExistsCache, false);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupName) throws ObjectNotFoundException {
        this.lockRead();
        try {
            Group group = (Group)this.getEntity(groupName, this.groupCache);
            if (group != null) {
                group = new GroupTemplate(group);
            }
            Group group2 = group;
            return group2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllGroupNames() {
        this.lockRead();
        try {
            List<String> list = this.getAllEntityNamesAsList(this.groupNamesCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAllGroupNames(List<String> groupNames) {
        this.lockWrite();
        try {
            this.storeAllEntityNames(groupNames, this.groupNamesCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGroup(Group group) {
        this.lockWrite();
        try {
            this.storeEntity((DirectoryEntity)new GroupTemplate(group), this.groupCache, this.groupNamesCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String groupName) {
        this.lockWrite();
        try {
            this.removeEntity(groupName, this.groupCache, this.groupNamesCache);
            this.removeAllRelations(groupName, this.groupUsersCache, this.userGroupsCache, this.userGroupMembershipExistsCache, true);
            this.removeAllRelations(groupName, this.groupChildGroupsCache, this.groupParentGroupsCache, this.groupGroupMembershipExistsCache, true);
            this.removeAllRelations(groupName, this.groupParentGroupsCache, this.groupChildGroupsCache, this.groupGroupMembershipExistsCache, false);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserMembersOfGroup(String groupName) {
        this.lockRead();
        try {
            List<String> list = this.getCompleteRelationshipsAsList(groupName, this.groupUsersCache, this.userCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUserMembersOfGroup(String groupName, Collection<String> userNames, boolean complete) {
        this.lockWrite();
        try {
            this.storeMembers(groupName, userNames, this.groupUsersCache, this.userGroupsCache, this.userGroupMembershipExistsCache, complete);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupMembershipsOfUser(String userName) {
        this.lockRead();
        try {
            List<String> list = this.getCompleteRelationshipsAsList(userName, this.userGroupsCache, this.groupCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGroupMembershipsOfUser(String userName, Collection<String> groupNames) {
        this.lockWrite();
        try {
            this.storeMemberships(userName, groupNames, this.userGroupsCache, this.groupUsersCache, this.userGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isUserGroupMember(String userName, String groupName) {
        this.lockRead();
        try {
            Boolean bl = this.isMember(userName, groupName, this.userGroupsCache, this.groupUsersCache, this.userGroupMembershipExistsCache);
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAsGroupMember(String userName, String groupName) {
        this.lockWrite();
        try {
            this.addMembership(userName, groupName, this.userGroupsCache, this.groupUsersCache, this.userGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAsGroupMember(String userName, String groupName) {
        this.lockWrite();
        try {
            this.removeMembership(userName, groupName, this.userGroupsCache, this.groupUsersCache, this.userGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupMembersOfGroup(String groupName) {
        this.lockRead();
        try {
            List<String> list = this.getCompleteRelationshipsAsList(groupName, this.groupChildGroupsCache, this.groupCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGroupMembersOfGroup(String groupName, Collection<String> childGroupNames, boolean complete) {
        this.lockWrite();
        try {
            this.storeMembers(groupName, childGroupNames, this.groupChildGroupsCache, this.groupParentGroupsCache, this.groupGroupMembershipExistsCache, complete);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupMembershipsOfGroup(String groupName) {
        this.lockRead();
        try {
            List<String> list = this.getCompleteRelationshipsAsList(groupName, this.groupParentGroupsCache, this.groupCache);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGroupMembershipsOfGroup(String groupName, Collection<String> parentGroupNames) {
        this.lockWrite();
        try {
            this.storeMemberships(groupName, parentGroupNames, this.groupParentGroupsCache, this.groupChildGroupsCache, this.groupGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isGroupGroupMember(String childGroup, String parentGroup) {
        this.lockRead();
        try {
            Boolean bl = this.isMember(childGroup, parentGroup, this.groupParentGroupsCache, this.groupChildGroupsCache, this.groupGroupMembershipExistsCache);
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupAsGroupMember(String childGroup, String parentGroup) {
        this.lockWrite();
        try {
            this.addMembership(childGroup, parentGroup, this.groupParentGroupsCache, this.groupChildGroupsCache, this.groupGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupAsGroupMember(String childGroup, String parentGroup) {
        this.lockWrite();
        try {
            this.removeMembership(childGroup, parentGroup, this.groupParentGroupsCache, this.groupChildGroupsCache, this.groupGroupMembershipExistsCache);
        }
        finally {
            this.unlockWrite();
        }
    }

    protected boolean isEventForThisCache(Event evt) {
        if (evt instanceof RemoteDirectoryEvent) {
            RemoteDirectoryEvent event = (RemoteDirectoryEvent)evt;
            return event.getDirectoryId() == this.directoryId;
        }
        return false;
    }

    protected boolean doHandleEvent(Event evt) {
        boolean handled = false;
        if (evt instanceof RemoteUserCreatedOrUpdatedEvent) {
            RemoteUserCreatedOrUpdatedEvent event = (RemoteUserCreatedOrUpdatedEvent)evt;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RemoteUserCreatedOrUpdatedEvent: " + event.getEntity()));
            }
            this.storeUser((User)event.getEntity());
            handled = true;
        } else if (evt instanceof RemoteUserDeletedEvent) {
            RemoteUserDeletedEvent event = (RemoteUserDeletedEvent)evt;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RemoteUserDeletedEvent: " + event.getEntityName()));
            }
            this.removeUser(event.getEntityName());
            handled = true;
        } else if (evt instanceof RemoteGroupCreatedOrUpdatedEvent) {
            RemoteGroupCreatedOrUpdatedEvent event = (RemoteGroupCreatedOrUpdatedEvent)evt;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RemoteGroupCreatedOrUpdatedEvent: " + event.getEntity()));
            }
            this.storeGroup((Group)event.getEntity());
            handled = true;
        } else if (evt instanceof RemoteGroupDeletedEvent) {
            RemoteGroupDeletedEvent event = (RemoteGroupDeletedEvent)evt;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RemoteGroupDeletedEvent: " + event.getEntityName()));
            }
            this.removeGroup(event.getEntityName());
            handled = true;
        }
        return handled;
    }

    public void handleEvent(Event evt) {
        if (this.isEventForThisCache(evt)) {
            this.doHandleEvent(evt);
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{RemoteDirectoryEvent.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryCacheStatistics getStatistics() {
        Statistics stats = null;
        try {
            this.lockRead();
            stats = new Statistics(this.userCache.getStatistics().getObjectCount(), this.groupCache.getStatistics().getObjectCount(), this.lastUpdated);
        }
        finally {
            this.unlockRead();
        }
        return stats;
    }

    class Statistics
    implements DirectoryCacheStatistics {
        private final int numberOfUsers;
        private final int numberOfGroups;
        private final Date lastUpdatedDate;

        public Statistics(int numberOfUsers, int numberOfGroups, Date lastUpdatedDate) {
            this.numberOfUsers = numberOfUsers;
            this.numberOfGroups = numberOfGroups;
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public int getNumberOfUsers() {
            return this.numberOfUsers;
        }

        public int getNumberOfGroups() {
            return this.numberOfGroups;
        }

        public Date getLastUpdated() {
            return this.lastUpdatedDate;
        }
    }
}

