/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.cache;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.directory.cache.DirectoryCache;
import com.atlassian.crowd.integration.directory.cache.LDAPDirectoryCache;
import com.atlassian.crowd.integration.directory.cache.model.EntityIdentifier;
import com.atlassian.crowd.integration.directory.cache.model.EntityType;
import com.atlassian.crowd.integration.directory.connector.LDAPDirectory;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.search.SearchResultsUtil;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLDAPDirectory
implements LDAPDirectory {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final LDAPDirectory directory;
    private final LDAPDirectoryCache cache;

    public CachingLDAPDirectory(LDAPDirectory directory, DirectoryCache directoryCache) {
        this.directory = directory;
        this.cache = (LDAPDirectoryCache)directoryCache;
    }

    public long getDirectoryId() {
        return this.directory.getDirectoryId();
    }

    public void setDirectoryId(long ID) {
        this.directory.setDirectoryId(ID);
    }

    public String getDescriptiveName() {
        return this.directory.getDescriptiveName();
    }

    public void setAttributes(Map<String, String> attributes) {
        this.directory.setAttributes(attributes);
    }

    public String getAttribute(String name) {
        return this.directory.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.directory.getAttributeNames();
    }

    public List<String> getAttributes(String name) {
        return this.directory.getAttributes(name);
    }

    public boolean hasAttribute(String name) {
        return this.directory.hasAttribute(name);
    }

    public void testConnection() throws DirectoryAccessException {
        this.directory.testConnection();
    }

    public User authenticate(String name, PasswordCredential credential) throws InactiveAccountException, InvalidAuthenticationException, ObjectNotFoundException, ExpiredCredentialException {
        return this.directory.authenticate(name, credential);
    }

    public boolean supportsNestedGroups() {
        return this.directory.supportsNestedGroups();
    }

    public void updateUserCredential(String name, PasswordCredential credential) throws ObjectNotFoundException, InvalidCredentialException {
        this.directory.updateUserCredential(name, credential);
    }

    public User renameUser(String oldName, String newName) throws ObjectNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("renameUser is not supported for caching LDAP directories");
    }

    public void storeUserAttributes(String username, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("custom user attributes are not yet supported for LDAP directories");
    }

    public void removeUserAttributes(String username, String attributeName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("custom user attributes are not yet supported for LDAP directories");
    }

    public User findUserByName(String name) throws ObjectNotFoundException {
        User user;
        Validate.notNull((Object)name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Called findUserByName: " + name));
        }
        if ((user = this.cache.getUser(name)) == null) {
            this.logger.debug((Object)"User does not exist in cache. Going to directory.");
            try {
                user = this.directory.findUserByName(name);
                this.logger.debug((Object)"Caching found user.");
                this.cache.storeUser(user);
            }
            catch (ObjectNotFoundException e) {
                this.logger.debug((Object)"User does not exist. Caching ObjectNotFound.");
                this.cache.removeUser(name);
                throw e;
            }
        } else {
            this.logger.debug((Object)"User retrieved from cache.");
        }
        return user;
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws ObjectNotFoundException {
        return (LDAPUserWithAttributes)this.findUserByName(name);
    }

    public Group findGroupByName(String name) throws ObjectNotFoundException {
        Group group;
        Validate.notNull((Object)name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Called findGroupByName: " + name));
        }
        if ((group = this.cache.getGroup(name)) == null) {
            this.logger.debug((Object)"Group does not exist in cache. Going to directory.");
            group = this.findGroupByNameFromServerAndCacheResult(name);
        } else {
            this.logger.debug((Object)"Group retrieved from cache.");
        }
        return group;
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws ObjectNotFoundException {
        return (LDAPGroupWithAttributes)this.findGroupByName(name);
    }

    public Group findGroupByNameFromServerAndCacheResult(String name) throws ObjectNotFoundException {
        try {
            Group group = this.directory.findGroupByName(name);
            this.logger.debug((Object)"Caching found group.");
            this.cache.storeGroup(group);
            return group;
        }
        catch (ObjectNotFoundException e) {
            this.logger.debug((Object)"Group does not exist. Caching ObjectNotFound.");
            this.cache.removeGroup(name);
            throw e;
        }
    }

    @Override
    public <T extends LDAPDirectoryEntity> T findEntityByDN(String dn, Class<T> entityClass) throws ObjectNotFoundException {
        EntityType type = EntityType.valueOf(entityClass);
        EntityIdentifier entityIdentifier = this.findEntityIdentifierFromDN(dn, type);
        switch (type) {
            case USER: {
                return (T)((LDAPDirectoryEntity)entityClass.cast(this.findUserByName(entityIdentifier.getName())));
            }
            case GROUP: {
                return (T)((LDAPDirectoryEntity)entityClass.cast(this.findGroupByName(entityIdentifier.getName())));
            }
        }
        throw new ObjectNotFoundException(entityClass, (Object)dn);
    }

    protected EntityIdentifier findEntityIdentifierFromDN(String dn, EntityType entityType) throws ObjectNotFoundException {
        EntityIdentifier identifier = this.cache.getEntityIdentifierForDn(dn);
        if (identifier == null) {
            try {
                LDAPDirectoryEntity entity = this.directory.findEntityByDN(dn, entityType.getLdapEntityClass());
                if (entity instanceof User) {
                    this.cache.storeUser((User)entity);
                } else if (entity instanceof Group) {
                    this.cache.storeGroup((Group)entity);
                }
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            identifier = this.cache.getEntityIdentifierForDn(dn);
        }
        if (identifier == null) {
            throw new ObjectNotFoundException(DirectoryEntity.class, (Object)dn);
        }
        return identifier;
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        try {
            this.findGroupByName(childGroup);
            this.findGroupByName(parentGroup);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        Boolean isMember = this.cache.isGroupGroupMember(childGroup, parentGroup);
        if (isMember == null) {
            isMember = this.directory.isGroupDirectGroupMember(childGroup, parentGroup);
            if (isMember.booleanValue()) {
                this.cache.setGroupAsGroupMember(childGroup, parentGroup);
            } else {
                this.cache.removeGroupAsGroupMember(childGroup, parentGroup);
            }
        }
        return isMember;
    }

    public boolean isUserDirectGroupMember(String userName, String groupName) {
        Validate.notEmpty((String)userName, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        try {
            this.findUserByName(userName);
            this.findGroupByName(groupName);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        Boolean isMember = this.cache.isUserGroupMember(userName, groupName);
        if (isMember == null) {
            isMember = this.directory.isUserDirectGroupMember(userName, groupName);
            if (isMember.booleanValue()) {
                this.cache.setUserAsGroupMember(userName, groupName);
            } else {
                this.cache.removeUserAsGroupMember(userName, groupName);
            }
        }
        return isMember;
    }

    public void addUserToGroup(String username, String groupName) throws ObjectNotFoundException {
        this.directory.addUserToGroup(username, groupName);
        this.findGroupByNameFromServerAndCacheResult(groupName);
    }

    public void addGroupToGroup(String parentGroup, String childGroup) throws ObjectNotFoundException, UnsupportedOperationException, InvalidMembershipException {
        this.directory.addGroupToGroup(parentGroup, childGroup);
        this.findGroupByNameFromServerAndCacheResult(parentGroup);
    }

    public void removeUserFromGroup(String username, String groupName) throws ObjectNotFoundException, MembershipNotFoundException {
        this.directory.removeUserFromGroup(username, groupName);
        this.findGroupByNameFromServerAndCacheResult(groupName);
    }

    public void removeGroupFromGroup(String parentGroup, String childGroup) throws ObjectNotFoundException, UnsupportedOperationException, InvalidMembershipException, MembershipNotFoundException {
        this.directory.removeGroupFromGroup(parentGroup, childGroup);
        this.findGroupByNameFromServerAndCacheResult(parentGroup);
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, ObjectNotFoundException, InvalidCredentialException {
        Validate.notNull((Object)user);
        if (user.getDirectoryId().longValue() != this.getDirectoryId()) {
            throw new InvalidUserException((User)user, "User with directory ID: " + user.getDirectoryId() + " cannot be added to remote directory with ID: " + this.getDirectoryId());
        }
        try {
            User addedUser = this.directory.addUser(user, credential);
            this.cache.storeUser(addedUser);
            return addedUser;
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeUser(user.getName());
            throw e;
        }
    }

    public User updateUser(UserTemplate user) throws ObjectNotFoundException, InvalidUserException {
        Validate.notNull((Object)user);
        if (user.getName() == null) {
            throw new IllegalArgumentException("Cannot update an empty user");
        }
        if (user.getDirectoryId().longValue() != this.getDirectoryId()) {
            throw new IllegalArgumentException("User with directory ID: " + user.getDirectoryId() + " cannot be updated in remote directory with ID: " + this.getDirectoryId());
        }
        try {
            User updatedUser = this.directory.updateUser(user);
            this.cache.storeUser(updatedUser);
            return updatedUser;
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeUser(user.getName());
            throw e;
        }
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, ObjectNotFoundException {
        Validate.notNull((Object)group);
        if (group.getDirectoryId().longValue() != this.getDirectoryId()) {
            throw new IllegalArgumentException("Group with directory ID: " + group.getDirectoryId() + " cannot be added to remote directory with ID: " + this.getDirectoryId());
        }
        try {
            Group addedGroup = this.directory.addGroup(group);
            this.cache.storeGroup(addedGroup);
            return addedGroup;
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeGroup(group.getName());
            throw e;
        }
    }

    public Group updateGroup(GroupTemplate group) throws ObjectNotFoundException, InvalidGroupException {
        Validate.notNull((Object)group);
        if (StringUtils.trimToNull((String)group.getName()) == null) {
            throw new IllegalArgumentException("Cannot find a group without a name");
        }
        if (group.getDirectoryId().longValue() != this.getDirectoryId()) {
            throw new IllegalArgumentException("Group with directory ID: " + group.getDirectoryId() + " cannot be updated in remote directory with ID: " + this.getDirectoryId());
        }
        try {
            Group updatedGroup = this.directory.updateGroup(group);
            this.cache.storeGroup(updatedGroup);
            return updatedGroup;
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeGroup(group.getName());
            throw e;
        }
    }

    public Group renameGroup(String oldName, String newName) throws ObjectNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("renameGroup is not supported for caching LDAP directories");
    }

    public void storeGroupAttributes(String groupName, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("custom group attributes are not yet supported for LDAP directories");
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("custom group attributes are not yet supported for LDAP directories");
    }

    public void removeUser(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name);
        try {
            this.directory.removeUser(name);
            this.cache.removeUser(name);
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeUser(name);
            throw e;
        }
    }

    public void removeGroup(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name);
        try {
            this.directory.removeGroup(name);
            this.cache.removeGroup(name);
        }
        catch (ObjectNotFoundException e) {
            this.cache.removeGroup(name);
            throw e;
        }
    }

    public List searchGroupRelationships(MembershipQuery query) {
        List<Object> relations;
        block10: {
            Validate.notNull((Object)query, (String)"query argument cannot be null");
            try {
                if (query.isFindMembers()) {
                    if (query.getEntityToMatch().getEntityType() == Entity.GROUP) {
                        if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                            relations = this.findUserMembersOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                            break block10;
                        }
                        if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
                            relations = this.findGroupMembersOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                            break block10;
                        }
                        throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                    }
                    throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                }
                if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
                    if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                        relations = this.findGroupMembershipsOfUser(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                        break block10;
                    }
                    if (query.getEntityToMatch().getEntityType() == Entity.GROUP) {
                        relations = this.findGroupMembershipsOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                        break block10;
                    }
                    throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                }
                throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            }
            catch (ObjectNotFoundException e) {
                relations = Collections.emptyList();
            }
        }
        if (query.getReturnType() == ReturnType.NAME) {
            return SearchResultsUtil.convertEntitiesToNames(relations);
        }
        return relations;
    }

    protected List<LDAPUserWithAttributes> findUserMembersOfGroup(String groupName, int startIndex, int maxResults) throws ObjectNotFoundException {
        return this.findEntityMembersOfGroup(groupName, LDAPUserWithAttributes.class, startIndex, maxResults);
    }

    protected List<LDAPGroupWithAttributes> findGroupMembersOfGroup(String groupName, int startIndex, int maxResults) throws ObjectNotFoundException {
        return this.findEntityMembersOfGroup(groupName, LDAPGroupWithAttributes.class, startIndex, maxResults);
    }

    private <T extends LDAPDirectoryEntity> List<T> findEntityMembersOfGroup(String groupName, Class<T> memberClass, int startIndex, int maxResults) throws ObjectNotFoundException {
        List results;
        LDAPGroupWithAttributes group = (LDAPGroupWithAttributes)this.findGroupByName(groupName);
        List memberDNs = group.getAttributes("memberDNs");
        if (memberDNs != null) {
            int totalResultSize;
            if (maxResults == -1) {
                results = new ArrayList();
                totalResultSize = -1;
            } else {
                results = new ArrayList(maxResults);
                totalResultSize = startIndex + maxResults;
            }
            for (String memberDN : memberDNs) {
                try {
                    T member = this.findEntityByDN(memberDN, memberClass);
                    results.add(member);
                }
                catch (ObjectNotFoundException e) {
                    // empty catch block
                }
                if (totalResultSize == -1 || results.size() < totalResultSize) continue;
                break;
            }
        } else {
            results = Collections.emptyList();
        }
        return SearchResultsUtil.constrainResults(results, startIndex, maxResults);
    }

    protected List<LDAPGroupWithAttributes> findGroupMembershipsOfUser(String username, int startIndex, int maxResults) throws ObjectNotFoundException {
        this.findUserByName(username);
        List<String> groupMembershipNames = this.cache.getGroupMembershipsOfUser(username);
        if (groupMembershipNames == null) {
            MembershipQuery queryForAllMemberships = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).membershipsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
            List groups = this.directory.searchGroupRelationships(queryForAllMemberships);
            groupMembershipNames = new ArrayList<String>();
            for (LDAPGroupWithAttributes group : groups) {
                this.cache.storeGroup((Group)group);
                groupMembershipNames.add(group.getName());
            }
            this.cache.storeGroupMembershipsOfUser(username, groupMembershipNames);
        }
        groupMembershipNames = SearchResultsUtil.constrainResults(groupMembershipNames, startIndex, maxResults);
        ArrayList<LDAPGroupWithAttributes> groups = new ArrayList<LDAPGroupWithAttributes>(groupMembershipNames.size());
        for (String groupName : groupMembershipNames) {
            try {
                LDAPGroupWithAttributes group;
                group = (LDAPGroupWithAttributes)this.findGroupByName(groupName);
                groups.add(group);
            }
            catch (ObjectNotFoundException e) {}
        }
        return groups;
    }

    protected List<LDAPGroupWithAttributes> findGroupMembershipsOfGroup(String groupName, int startIndex, int maxResults) throws ObjectNotFoundException {
        this.findGroupByName(groupName);
        List<String> groupMembershipNames = this.cache.getGroupMembershipsOfGroup(groupName);
        if (groupMembershipNames == null) {
            MembershipQuery queryForAllMemberships = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).membershipsOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
            List groups = this.directory.searchGroupRelationships(queryForAllMemberships);
            groupMembershipNames = new ArrayList<String>();
            for (LDAPGroupWithAttributes group : groups) {
                this.cache.storeGroup((Group)group);
                groupMembershipNames.add(group.getName());
            }
            this.cache.storeGroupMembershipsOfGroup(groupName, groupMembershipNames);
        }
        groupMembershipNames = SearchResultsUtil.constrainResults(groupMembershipNames, startIndex, maxResults);
        ArrayList<LDAPGroupWithAttributes> groups = new ArrayList<LDAPGroupWithAttributes>(groupMembershipNames.size());
        for (String parentGroupName : groupMembershipNames) {
            try {
                LDAPGroupWithAttributes group;
                group = (LDAPGroupWithAttributes)this.findGroupByName(parentGroupName);
                groups.add(group);
            }
            catch (ObjectNotFoundException e) {}
        }
        return groups;
    }

    protected boolean isFindAllEntities(EntityQuery query) {
        return query.getMaxResults() == -1 && query.getStartIndex() == 0 && query.getSearchRestriction() instanceof NullRestriction;
    }

    protected List<LDAPUserWithAttributes> findAllUsersFromDirectory() {
        return this.directory.searchUsers(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
    }

    protected List<LDAPGroupWithAttributes> findAllGroupsFromDirectory() {
        return this.directory.searchGroups(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
    }

    protected List<LDAPUserWithAttributes> findAllUsers() {
        List<String> allUserNames = this.cache.getAllUserNames();
        List<LDAPUserWithAttributes> users = null;
        if (allUserNames == null) {
            this.logger.debug((Object)"All user names are not cached. Going to directory to find all users.");
            users = this.findAllUsersFromDirectory();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Caching all " + users.size() + " users returned from the directory."));
            }
            allUserNames = new ArrayList<String>(users.size());
            for (LDAPUserWithAttributes user : users) {
                allUserNames.add(user.getName());
                this.cache.storeUser((User)user);
            }
            this.cache.storeAllUserNames(allUserNames);
        } else {
            this.logger.debug((Object)"All user names are cached. Retrieving from cache.");
            users = new ArrayList<LDAPUserWithAttributes>(allUserNames.size());
            for (String userName : allUserNames) {
                try {
                    LDAPUserWithAttributes user = (LDAPUserWithAttributes)this.findUserByName(userName);
                    users.add(user);
                }
                catch (ObjectNotFoundException e) {}
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LDAPGroupWithAttributes> findAllGroups() {
        List<LDAPGroupWithAttributes> groups = null;
        try {
            UtilTimerStack.push((String)"CachingLDAPDirectory - findAllGroups");
            List<String> allGroupNames = this.cache.getAllGroupNames();
            if (allGroupNames == null) {
                this.logger.debug((Object)"All group names are not cached. Going to directory to find all groups.");
                groups = this.findAllGroupsFromDirectory();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Caching all " + groups.size() + " groups returned from the directory."));
                }
                allGroupNames = new ArrayList<String>(groups.size());
                for (LDAPGroupWithAttributes group : groups) {
                    allGroupNames.add(group.getName());
                    this.cache.storeGroup((Group)group);
                }
                this.cache.storeAllGroupNames(allGroupNames);
            } else {
                this.logger.debug((Object)"All group names are cached. Retrieving from cache.");
                groups = new ArrayList<LDAPGroupWithAttributes>(allGroupNames.size());
                for (String groupName : allGroupNames) {
                    try {
                        LDAPGroupWithAttributes group = (LDAPGroupWithAttributes)this.findGroupByName(groupName);
                        groups.add(group);
                    }
                    catch (ObjectNotFoundException e) {}
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"CachingLDAPDirectory - findAllGroups");
        }
        return groups;
    }

    private EntityQuery queryForEntities(EntityQuery query) {
        return new EntityQuery(query, ReturnType.ENTITY);
    }

    public List searchGroups(EntityQuery query) {
        List groups;
        Validate.notNull((Object)query, (String)"query argument cannot be null");
        if (this.isFindAllEntities(query)) {
            this.logger.debug((Object)"Call to find all groups");
            groups = this.findAllGroups();
        } else {
            this.logger.debug((Object)"Call to search groups, going to directory");
            groups = this.directory.searchGroups(this.queryForEntities(query));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Caching search results: " + groups.size() + " groups."));
            }
            for (LDAPGroupWithAttributes group : groups) {
                this.cache.storeGroup((Group)group);
            }
        }
        if (query.getReturnType() == ReturnType.NAME) {
            return SearchResultsUtil.convertEntitiesToNames(groups);
        }
        return groups;
    }

    public List searchUsers(EntityQuery query) {
        List users;
        Validate.notNull((Object)query, (String)"Entity query cannot be null");
        if (this.isFindAllEntities(query)) {
            this.logger.debug((Object)"Call to find all users");
            users = this.findAllUsers();
        } else {
            this.logger.debug((Object)"Call to search users, going to directory");
            users = this.directory.searchUsers(this.queryForEntities(query));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Caching search results: " + users.size() + " users."));
            }
            for (LDAPUserWithAttributes user : users) {
                this.cache.storeUser((User)user);
            }
        }
        if (query.getReturnType() == ReturnType.NAME) {
            return SearchResultsUtil.convertEntitiesToNames(users);
        }
        return users;
    }
}

