/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.authentication;

import com.atlassian.crowd.authentication.TrustedProxyManager;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.RemoteAddressHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedProxyManagerImpl
implements TrustedProxyManager {
    private static final Logger logger = Logger.getLogger(TrustedProxyManagerImpl.class);
    private PropertyManager propertyManager;
    private CacheManager cacheManager;
    private static final String DELIMITER = ",";
    private static final String CACHE_KEY = TrustedProxyManagerImpl.class.getName();
    private static final String REQUESTED_PROXIES_CACHE_KEY = TrustedProxyManagerImpl.class.getName() + "_requested_proxies";

    public boolean isTrusted(String remoteAddress) {
        List<String> trustedProxies = this.getListFromCache();
        HashMap requestedProxies = (HashMap)this.getRequestedProxiesMapFromCache();
        if (requestedProxies.containsKey(remoteAddress)) {
            return (Boolean)requestedProxies.get(remoteAddress);
        }
        RemoteAddress requestProxyAddress = new RemoteAddress(remoteAddress);
        for (String trustedProxy : trustedProxies) {
            if (!RemoteAddressHelper.isAddressAllowed((RemoteAddress)new RemoteAddress(trustedProxy), (RemoteAddress)requestProxyAddress)) continue;
            requestedProxies.put(remoteAddress, true);
            this.cacheManager.put(REQUESTED_PROXIES_CACHE_KEY, (Serializable)requestedProxies);
            return true;
        }
        requestedProxies.put(remoteAddress, false);
        this.cacheManager.put(REQUESTED_PROXIES_CACHE_KEY, (Serializable)requestedProxies);
        return false;
    }

    public List<String> getList() {
        return this.getListFromCache();
    }

    public boolean add(String remoteAddress) {
        List<String> trustedProxies = this.getListFromCache();
        if (!trustedProxies.contains(remoteAddress)) {
            this.cacheManager.remove(REQUESTED_PROXIES_CACHE_KEY);
            trustedProxies.add(remoteAddress);
            return this.saveList(trustedProxies);
        }
        return false;
    }

    public void remove(String remoteAddress) {
        List<String> trustedProxies = this.getListFromCache();
        if (trustedProxies.contains(remoteAddress)) {
            this.cacheManager.remove(REQUESTED_PROXIES_CACHE_KEY);
            trustedProxies.remove(remoteAddress);
            this.saveList(trustedProxies);
        }
    }

    protected String getProperty() {
        String proxies = null;
        try {
            proxies = this.propertyManager.getTrustedProxyServers();
        }
        catch (PropertyManagerException e) {
            logger.debug((Object)"No proxies loaded", (Throwable)e);
        }
        if (StringUtils.isBlank((String)proxies)) {
            proxies = null;
        }
        return proxies;
    }

    protected boolean setProperty(String value) {
        try {
            this.propertyManager.setTrustedProxyServers(value);
            return true;
        }
        catch (DataAccessException e) {
            logger.warn((Object)"Unable to save list of trusted proxy servers", (Throwable)e);
            return false;
        }
    }

    protected Map<String, Boolean> getRequestedProxiesMapFromCache() {
        try {
            return (HashMap)this.cacheManager.get(REQUESTED_PROXIES_CACHE_KEY);
        }
        catch (NotInCacheException notInCacheException) {
            return new HashMap<String, Boolean>();
        }
    }

    protected List<String> getListFromCache() {
        try {
            return (List)this.cacheManager.get(CACHE_KEY);
        }
        catch (NotInCacheException e) {
            ArrayList<String> proxyList = new ArrayList<String>(1);
            String proxies = this.getProperty();
            if (proxies != null) {
                String[] proxyStrings = proxies.split(DELIMITER);
                for (int i = 0; i < proxyStrings.length; ++i) {
                    String proxy = proxyStrings[i];
                    proxyList.add(proxy);
                }
            }
            this.cacheManager.put(CACHE_KEY, proxyList);
            return proxyList;
        }
    }

    protected boolean saveList(List<String> trustedProxies) {
        StringBuffer proxies = new StringBuffer();
        Iterator<String> proxyIt = trustedProxies.iterator();
        while (proxyIt.hasNext()) {
            proxies.append((Object)proxyIt.next());
            if (!proxyIt.hasNext()) continue;
            proxies.append(DELIMITER);
        }
        this.cacheManager.remove(CACHE_KEY);
        return this.setProperty(proxies.toString());
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

