/*
 * Copyright (c) 2003 by Atlassian Software Systems Pty. Ltd.
 * All rights reserved.
 */
package com.atlassian.crowd.core.tiny;

import java.io.Serializable;


/**
 * A simple type to represent a pair of objects.
 */
public final class PairType implements Serializable {
    private static final long serialVersionUID = 4970043384204083681L;

    //~ Instance variables ---------------------------------------------------------------------------------------------

    private final Serializable key;
    private final String value;

    //~ Constructors ---------------------------------------------------------------------------------------------------

    public PairType(Serializable key, String value) {
        this.key = key;
        this.value = value;
    }

    //~ Methods --------------------------------------------------------------------------------------------------------

    public Serializable getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public String toString() {
        return key + "/" + value;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PairType)) return false;

        final PairType pairType = (PairType) o;

        return key.equals(pairType.key) && value.equals(pairType.value);
    }

    public int hashCode() {
        return 29 * key.hashCode() + value.hashCode();
    }
}
