package com.atlassian.crowd.common.properties;

import javax.annotation.Nonnull;

public class StringSystemProperty extends AbstractSystemProperty<String> {
    public StringSystemProperty(@Nonnull String propertyName, @Nonnull String defaultValue) {
        super(propertyName, defaultValue);
    }

    @Nonnull
    public String getValue() {
        return System.getProperty(propertyName, defaultValue);
    }
}
