package com.atlassian.crowd.common.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.util.Optional;

public class IntegerSystemProperty extends AbstractSystemProperty<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(IntegerSystemProperty.class);

    public IntegerSystemProperty(@Nonnull String propertyName, int defaultValue) {
        super(propertyName, defaultValue);
    }

    @Nonnull
    public Integer getValue() {
        final String rawValue = System.getProperty(propertyName);
        try {
            return Optional.ofNullable(System.getProperty(propertyName))
                    .map(Integer::parseInt)
                    .orElse(defaultValue);
        } catch (NumberFormatException e) {
            logger.warn("Illegal value of system property " + propertyName + ", expected an integer but was: " + rawValue);
            return defaultValue;
        }
    }
}
