package com.atlassian.crowd.common.analytics.statistics.collectors;

/**
 * Handles collecting a single set of statistics, and emitting the related analytics event
 */
public interface StatisticsCollector<T> {
    /**
     * @return the statistics event to publish
     */
    Iterable<T> collect();

    /**
     * Determines whether StatisticsCollector should run on each node OR once per cluster.
     *
     * @return true if StatisticsCollector should run on each node, false if once per cluster.
     */
    default boolean isPerNodeCollector() {
        return false;
    }
}
