/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.common.properties;

import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractSystemProperty<T> {
    protected final String propertyName;
    protected final T defaultValue;

    protected AbstractSystemProperty(@Nonnull String propertyName, @Nonnull T defaultValue) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    @Nonnull
    public String getName() {
        return this.propertyName;
    }

    @Nonnull
    public abstract T getValue();

    public void setValue(@Nonnull T value) {
        this.setRawValue(value.toString());
    }

    public void setRawValue(@Nonnull String value) {
        System.setProperty(this.propertyName, value);
    }

    public void clearValue() {
        System.clearProperty(this.propertyName);
    }
}

