package com.atlassian.crowd.common.properties;

import javax.annotation.Nonnull;
import java.util.Optional;

public class BooleanSystemProperty extends AbstractSystemProperty<Boolean> {
    public BooleanSystemProperty(@Nonnull String propertyName, boolean defaultValue) {
        super(propertyName, defaultValue);
    }

    @Nonnull
    @Override
    public Boolean getValue() {
        return Optional.ofNullable(System.getProperty(propertyName))
                .map(Boolean::parseBoolean)
                .orElse(defaultValue);
    }
}
