package com.atlassian.crowd.common.properties;

import javax.annotation.Nonnull;
import java.util.Objects;

public abstract class AbstractSystemProperty<T> {
    protected final String propertyName;
    protected final T defaultValue;

    protected AbstractSystemProperty(@Nonnull String propertyName, @Nonnull T defaultValue) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    @Nonnull
    public String getName() {
        return propertyName;
    }

    /**
     * Returns the value of this system property or the default if it's not set.
     */
    @Nonnull
    public abstract T getValue();

    /**
     * Sets the value of this system property.
     */
    public void setValue(@Nonnull T value) {
        setRawValue(value.toString());
    }

    public void setRawValue(@Nonnull String value) {
        System.setProperty(propertyName, value);
    }

    /**
     * Clears the value of this system property.
     */
    public void clearValue() {
        System.clearProperty(propertyName);
    }
}
