package com.atlassian.crowd.common.properties;

import com.atlassian.crowd.common.util.AdditionalHeaders;

import java.time.temporal.ChronoUnit;

/**
 * System properties.
 */
public class SystemProperties {

    private SystemProperties() {
    }

    /**
     * When set to true, Crowd will add {@link AdditionalHeaders#HEADER_X_AUSERNAME} header containing username of logged in
     * user for all HTTP requests (including REST). This header can be utilized in Tomcat's access logs.
     */
    public static final BooleanSystemProperty INCLUDE_USERNAME_HEADER_IN_RESPONSES =
            new BooleanSystemProperty("crowd.username.header", false);

    /**
     * When set to true, Crowd will add {@link AdditionalHeaders#HEADER_X_AAPPNAME} header containing application name of
     * application making REST requests to Crowd. This header can be utilized in Tomcat's access logs.
     */
    public static final BooleanSystemProperty INCLUDE_APPNAME_HEADER_IN_RESPONSES =
            new BooleanSystemProperty("crowd.appname.header", false);

    /**
     * Defines whether optimized version of outgoing membership synchronization should be used.
     * From manual tests of application with 1M users in 4 directories enabling this feature saves ~2h time of
     * full synchronisation of memberships and increases memory consumption by ~300MB.
     */
    public static final BooleanSystemProperty MEMBERSHIPS_SYNC_IMPROVEMENT_ENABLED =
            new BooleanSystemProperty("crowd.sync.memberships.improvement.enabled", true);
    /**
     * When set to an integer, Crowd web application /status endpoint will memoize database health check for a provided number of
     * seconds instead of the default value
     */
    public static final DurationSystemProperty APPLICATION_STATUS_CACHE_DURATION =
            new DurationSystemProperty("crowd.application.status.cache.in.seconds", ChronoUnit.SECONDS, 10L);

    public static final BooleanSystemProperty ATLASSIAN_DEV_MODE = new BooleanSystemProperty("atlassian.dev.mode", false);

    /**
     * Setting this to "true" enables the special character (_) escaping
     */
    public static final BooleanSystemProperty AUDITLOG_SEARCH_ESCAPE_SPECIAL_CHARACTERS_ENABLED = new BooleanSystemProperty("crowd.audit.log.escape_special_characters", true);
}
