package com.atlassian.crowd.common.properties;

import java.time.temporal.ChronoUnit;

public class EncryptionProperties {
    private EncryptionProperties() {
    }

    /**
     * When set to true, upgrade task which encrypts Crowd's ldap passwords will be disabled.
     */
    public static final BooleanSystemProperty ENCRYPTION_DURING_UPGRADE_DISABLED =
            new BooleanSystemProperty("crowd.encryption.upgrade.disabled", false);
    /**
     * When set to true, Crowd will not cache encryption/decryption results.
     */
    public static final BooleanSystemProperty ENRCYPTION_CACHE_ENABLED =
            new BooleanSystemProperty("crowd.encryption.cache.enabled", true);
    /**
     * Specifies the maximum number of entries the encryption and decryption cache may contain.
     */
    public static final IntegerSystemProperty ENCRYPTION_CACHE_MAX_SIZE =
            new IntegerSystemProperty("crowd.encryption.cache.max.size", 1000);
    /**
     * Specifies the amount of time in minutes after the entry will be removed from cache. The time is measured since
     * the entry's creation, the most recent replacement of its value and its last access.
     */
    public static final DurationSystemProperty ENCRYPTION_CACHE_EXPIRATION =
            new DurationSystemProperty("crowd.encryption.cache.expire.minutes", ChronoUnit.MINUTES, 10);

    /**
     * If set to true Crowd will set encryption keys filesystem ownership attributes to be accessible only by owner.
     */
    public static final BooleanSystemProperty SET_ENCRYPTION_KEYS_OWNERSHIP_ATTRIBUTES =
            new BooleanSystemProperty("crowd.encryption.keys.set.ownership.attributes", false);

}
