/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.ClassUtils;

public class ProxyUtil {
    private ProxyUtil() {
    }

    public static <T> T runWithContextClassLoader(ClassLoader classLoader, T service) {
        return ProxyUtil.newProxy(service, (proxy, method, args) -> {
            Thread currentThread = Thread.currentThread();
            ClassLoader original = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(classLoader);
                Object object = method.invoke(service, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            finally {
                currentThread.setContextClassLoader(original);
            }
        });
    }

    public static <T> T newProxy(T service, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.getAllInterfaces(service.getClass()).toArray(new Class[0]), handler);
    }
}

