package com.atlassian.crowd.model.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Data object containing the configuration for user filtering based on groups
 */
public class AzureGroupFiltersConfiguration {

    private final boolean enabled;

    private final Set<String> groupsNames;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    public AzureGroupFiltersConfiguration(boolean enabled, Iterable<String> groupsNames) {
        this.enabled = enabled;
        this.groupsNames = groupsNames != null ? ImmutableSet.copyOf(groupsNames) : Collections.emptySet();
    }

    public boolean isEnabled() {
        return enabled;
    }

    public Set<String> getGroupsNames() {
        return groupsNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AzureGroupFiltersConfiguration that = (AzureGroupFiltersConfiguration) o;

        return Objects.equals(this.isEnabled(), that.isEnabled()) && Objects.equals(this.getGroupsNames(), that.getGroupsNames());
    }

    @Override
    public int hashCode() {
        return Objects.hash(isEnabled(), getGroupsNames());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("enabled", isEnabled())
                .add("groupsNames", getGroupsNames())
                .toString();
    }
}
