package com.atlassian.crowd.directory.rest.util;

import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipGroup;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipUser;

/**
 * Utility class for checking the type of a directory object
 */
public final class MembershipFilterUtil {

    private MembershipFilterUtil() {}

    /**
     * @param directoryObject the directory object to check
     * @return true if the directory object is a group
     */
    public static boolean isGroup(DirectoryObject directoryObject) {
        return directoryObject instanceof GraphMembershipGroup;
    }

    /**
     * @param directoryObject the directory object to check
     * @return true if the directory object is an user
     */
    public static boolean isUser(DirectoryObject directoryObject) {
        return directoryObject instanceof GraphMembershipUser;
    }
}
