package com.atlassian.crowd.directory.rest.util;

import com.google.common.base.Charsets;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JerseyLoggingFilter extends ClientFilter {

    private static final Logger log = LoggerFactory.getLogger(JerseyLoggingFilter.class);

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        final ClientResponse response = getNext().handle(cr);
        logResponse(cr, response);
        return response;
    }

    private void logResponse(ClientRequest cr, ClientResponse response) {
        if (log.isDebugEnabled()) {
            final InputStream inputStream = response.getEntityInputStream();
            try {
                final byte[] entity = IOUtils.toByteArray(inputStream);
                final String entityAsString = new String(entity, 0, entity.length, Charsets.UTF_8);
                log.debug("Request URI {}, Response body: {}", cr.getURI(), entityAsString);
                response.setEntityInputStream(new ByteArrayInputStream(entity));
            } catch (IOException e) {
                throw new ClientHandlerException(e);
            } finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }
}
