package com.atlassian.crowd.directory.rest.entity.user.password;

import com.atlassian.crowd.directory.rest.entity.user.GraphUser;
import org.codehaus.jackson.annotate.JsonProperty;

public class GraphUserWithPassword extends GraphUser {

    @JsonProperty("passwordProfile")
    private final PasswordProfile passwordProfile;

    public GraphUserWithPassword(final String id,
                                 final String displayName,
                                 final String givenName,
                                 final String mail,
                                 final String surname,
                                 final String userPrincipalName,
                                 final Boolean accountEnabled,
                                 final PasswordProfile passwordProfile) {
        super(id, displayName, givenName, mail, surname, userPrincipalName, accountEnabled);
        this.passwordProfile = passwordProfile;
    }

    private GraphUserWithPassword() {
        this.passwordProfile = null;
    }

    public PasswordProfile getPasswordProfile() {
        return passwordProfile;
    }
}
