package com.atlassian.crowd.directory.rest.entity.user;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a user returned from the /users endpoint
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphUser {

    @JsonProperty("id")
    private final String id;

    @JsonProperty("displayName")
    private final String displayName;

    @JsonProperty("givenName")
    private final String givenName;

    @JsonProperty("mail")
    private final String mail;

    @JsonProperty("surname")
    private final String surname;

    @JsonProperty("userPrincipalName")
    private final String userPrincipalName;

    @JsonProperty("accountEnabled")
    private final Boolean accountEnabled;

    public GraphUser() {
        this.id = null;
        this.displayName = null;
        this.givenName = null;
        this.mail = null;
        this.surname = null;
        this.userPrincipalName = null;
        this.accountEnabled = null;
    }

    public GraphUser(String userPrincipalName) {
        this.id = null;
        this.displayName = null;
        this.givenName = null;
        this.mail = null;
        this.surname = null;
        this.accountEnabled = null;
        this.userPrincipalName = userPrincipalName;
    }

    public GraphUser(final String id, final String displayName, final String givenName, final String mail, final String surname, final String userPrincipalName, final Boolean accountEnabled) {
        this.id = id;
        this.displayName = displayName;
        this.givenName = givenName;
        this.mail = mail;
        this.surname = surname;
        this.userPrincipalName = userPrincipalName;
        this.accountEnabled = accountEnabled;
    }

    public String getId() {
        return id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getGivenName() {
        return givenName;
    }

    public String getMail() {
        return mail;
    }

    public String getSurname() {
        return surname;
    }

    public String getUserPrincipalName() {
        return userPrincipalName;
    }

    public Boolean getAccountEnabled() {
        return accountEnabled;
    }
}
