package com.atlassian.crowd.directory.rest.entity.membership;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a user returned from a membership related endpoint
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphMembershipUser extends DirectoryObject {

    @JsonProperty("givenName")
    private final String givenName;

    @JsonProperty("mail")
    private final String mail;

    @JsonProperty("surname")
    private final String surname;

    @JsonProperty("userPrincipalName")
    private final String userPrincipalName;

    @JsonProperty("accountEnabled")
    private final Boolean accountEnabled;

    protected GraphMembershipUser() {
        super(null, null);
        givenName = null;
        mail = null;
        surname = null;
        userPrincipalName = null;
        accountEnabled = null;
    }

    public GraphMembershipUser(final String id, final String displayName, final String givenName, final String mail, final String surname, final String userPrincipalName, final Boolean accountEnabled) {
        super(displayName, id);
        this.givenName = givenName;
        this.mail = mail;
        this.surname = surname;
        this.userPrincipalName = userPrincipalName;
        this.accountEnabled = accountEnabled;
    }

    public String getGivenName() {
        return givenName;
    }

    public String getMail() {
        return mail;
    }

    public String getSurname() {
        return surname;
    }

    public String getUserPrincipalName() {
        return userPrincipalName;
    }

    public Boolean getAccountEnabled() {
        return accountEnabled;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getId() {
        return id;
    }
}
