package com.atlassian.crowd.directory.rest.entity.membership;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a group returned from a membership related endpoint
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphMembershipGroup extends DirectoryObject {

    @JsonProperty("description")
    private final String description;

    private GraphMembershipGroup() {
        super(null, null);
        this.description = null;
    }

    public GraphMembershipGroup(final String id, final String displayName, String description) {
        super(displayName, id);
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getId() {
        return id;
    }
}
