package com.atlassian.crowd.directory.rest.entity.membership;

import com.atlassian.crowd.directory.rest.resolver.DirectoryObjectTypeIdResolver;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.annotate.JsonTypeIdResolver;

/**
 * Represents a generic directory object returned from a membership related endpoint. Instances of this type represent
 * directory objects that were not users or groups (ie directory roles)
 */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.CUSTOM,
        include = JsonTypeInfo.As.PROPERTY,
        property = "@odata.type"
)
@JsonTypeIdResolver(DirectoryObjectTypeIdResolver.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DirectoryObject {

    @JsonProperty("displayName")
    protected final String displayName;

    @JsonProperty("id")
    protected final String id;

    protected DirectoryObject() {
        this.displayName = null;
        this.id = null;
    }

    public DirectoryObject(String displayName, String id) {
        this.displayName = displayName;
        this.id = id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getId() {
        return id;
    }
}
