package com.atlassian.crowd.directory.rest.entity.group;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a group returned from the /groups endpoint
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphGroup {

    @JsonProperty("displayName")
    private final String displayName;

    @JsonProperty("id")
    private final String id;

    @JsonProperty("description")
    private final String description;

    public GraphGroup() {
        this.id = null;
        this.displayName = null;
        this.description = null;
    }

    public GraphGroup(String displayName) {
        this.id = null;
        this.description = null;
        this.displayName = displayName;
    }

    public GraphGroup(final String id, final String displayName, String description) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GraphGroup [displayName=");
        builder.append(displayName);
        builder.append(", id=");
        builder.append(id);
        builder.append(", description=");
        builder.append(description);
        builder.append("]");
        return builder.toString();
    }
}
