package com.atlassian.crowd.directory.rest.entity.delta;

import com.atlassian.crowd.directory.rest.entity.PageableGraphList;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.List;

/**
 * Represents a pageable list of results obtained from an Azure AD delta. In addition
 * to results and the optional next page link it will contain a link for change tracking if the page of results represented
 * by this object is the last one.
 * @param <T> The type of results
 */
public abstract class PageableDeltaQueryGraphList<T> extends PageableGraphList<T> {

    @JsonProperty("@odata.deltaLink")
    private final String deltaLink;

    protected PageableDeltaQueryGraphList() {
        deltaLink = null;
    }

    protected PageableDeltaQueryGraphList(String nextLink, List<T> entries) {
        super(nextLink, entries);
        deltaLink = null;
    }

    public PageableDeltaQueryGraphList(String nextLink, List<T> entries, String deltaLink) {
        super(nextLink, entries);
        this.deltaLink = deltaLink;
    }

    public String getDeltaLink() {
        return deltaLink;
    }
}
