package com.atlassian.crowd.directory.rest.entity.delta;

import com.atlassian.crowd.directory.rest.entity.user.GraphUser;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a user fetched from a Microsoft Graph delta query. In addition to regular user properties an optional
 * removed marker may be present
 */
public class GraphDeltaQueryUser extends GraphUser implements GraphDeletableObject {

    @JsonProperty(GraphDeletableObject.REMOVED_PROPERTY_NAME)
    private final GraphDeltaQueryRemoved removed;

    private GraphDeltaQueryUser() {
        this.removed = null;
    }

    public GraphDeltaQueryUser(String userPrincipalName) {
        super(userPrincipalName);
        this.removed = null;
    }

    public GraphDeltaQueryUser(String id, String displayName, String givenName, String mail, String surname, String userPrincipalName, Boolean accountEnabled) {
        super(id, displayName, givenName, mail, surname, userPrincipalName, accountEnabled);
        this.removed = null;
    }
    public GraphDeltaQueryUser(String id, String displayName, String givenName, String mail, String surname, String userPrincipalName, Boolean accountEnabled, GraphDeltaQueryRemoved removed) {
        super(id, displayName, givenName, mail, surname, userPrincipalName, accountEnabled);
        this.removed = removed;
    }

    @Override
    public GraphDeltaQueryRemoved getRemoved() {
        return removed;
    }
}
