package com.atlassian.crowd.directory.rest.entity.delta;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents metadata about an object's removal from Azure AD.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphDeltaQueryRemoved {

    @JsonProperty
    private final String reason;

    public GraphDeltaQueryRemoved(String reason) {
        this.reason = reason;
    }

    private GraphDeltaQueryRemoved() {
        this.reason = null;
    }

    public String getReason() {
        return reason;
    }
}
