package com.atlassian.crowd.directory.rest.entity.delta;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a membership obtained from Azure AD. Contains the type of the child object the the child object's id.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphDeltaQueryMembership implements GraphDeletableObject {

    @JsonProperty("@odata.type")
    private final String type;

    @JsonProperty("id")
    private final String id;

    @JsonProperty(GraphDeletableObject.REMOVED_PROPERTY_NAME)
    private final GraphDeltaQueryRemoved removed;

    public GraphDeltaQueryMembership(String type, String id, GraphDeltaQueryRemoved removed) {
        this.type = type;
        this.id = id;
        this.removed = removed;
    }

    private GraphDeltaQueryMembership() {
        this.type = null;
        this.id = null;
        this.removed = null;
    }

    public String getType() {
        return type;
    }

    public String getId() {
        return id;
    }

    @Override
    public GraphDeltaQueryRemoved getRemoved() {
        return removed;
    }
}
