package com.atlassian.crowd.directory.rest.entity.delta;

import com.atlassian.crowd.directory.rest.entity.group.GraphGroup;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Collections;
import java.util.List;

/**
 * Represents a group fetched from a Microsoft Graph delta query. In addition to regular group properties a collection
 * of changed memberships and an optional removed marker are present.
 */
public class GraphDeltaQueryGroup extends GraphGroup implements GraphDeletableObject {

    @JsonProperty("members@delta")
    private final List<GraphDeltaQueryMembership> members;

    @JsonProperty(GraphDeletableObject.REMOVED_PROPERTY_NAME)
    private final GraphDeltaQueryRemoved removed;

    private GraphDeltaQueryGroup() {
        this.members = Collections.emptyList();
        this.removed = null;
    }

    public GraphDeltaQueryGroup(String displayName) {
        super(displayName);
        this.members = Collections.emptyList();
        this.removed = null;
    }

    public GraphDeltaQueryGroup(String id, String displayName, String description) {
        super(id, displayName, description);
        this.members = Collections.emptyList();
        this.removed = null;
    }

    public GraphDeltaQueryGroup(String id, String displayName, String description,
                                List<GraphDeltaQueryMembership> members, GraphDeltaQueryRemoved removed) {
        super(id, displayName, description);
        this.members = members;
        this.removed = removed;
    }

    public List<GraphDeltaQueryMembership> getMembers() {
        return members;
    }

    @Override
    public GraphDeltaQueryRemoved getRemoved() {
        return removed;
    }
}
