package com.atlassian.crowd.directory.rest.entity;

import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Represents a pageable list of results obtained from Azure AD. In addition
 * to results it can optionally contain a link to the next page.
 * @param <T> The type of results
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class PageableGraphList<T> {

    @JsonProperty("@odata.nextLink")
    private final String nextLink;

    @JsonProperty("value")
    private final List<T> entries;

    protected PageableGraphList() {
        this.nextLink = null;
        this.entries = null;
    }

    protected PageableGraphList(String nextLink, List<T> entries) {
        this.nextLink = nextLink;
        this.entries = entries;
    }

    public String getNextLink() {
        return nextLink;
    }

    public List<T> getEntries() {
        return entries;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PageableGraphList [nextLink=");
        builder.append(nextLink);
        builder.append(", entries=");
        builder.append(entries);
        builder.append("]");
        return builder.toString();
    }
}
