package com.atlassian.crowd.directory.rest.entity;

import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.List;

/**
 * Represents a collection of directory objects, returned from the members and memberOf navigational property endpoints,
 * which may be either of the generic {@link DirectoryObject} type or more concrete types
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphDirectoryObjectList extends PageableGraphList<DirectoryObject> {

    private GraphDirectoryObjectList() {
    }

    public GraphDirectoryObjectList(String nextLink, List<DirectoryObject> entries) {
        super(nextLink, entries);
    }
}
