package com.atlassian.crowd.directory.rest.endpoint;

/**
 * Represents a set of Azure Ad regions which are supported by Crowd
 */
public enum DefaultRegion {
    //IMPORTANT NOTE: These values are persisted in the database
    GLOBAL("https://graph.microsoft.com", "https://login.windows.net"),

    // https://docs.microsoft.com/en-us/azure/germany/germany-developer-guide
    GERMANY("https://graph.microsoft.de", "https://login.microsoftonline.de"),

    // https://msdn.microsoft.com/en-us/office/office365/api/o365-china-endpoints
    // https://docs.microsoft.com/en-us/azure/china/china-get-started-developer-guide
    CHINA("https://microsoftgraph.chinacloudapi.cn", "https://login.chinacloudapi.cn"),

    // https://docs.microsoft.com/en-us/azure/azure-government/documentation-government-developer-guide
    UNITED_STATES_GOVERNMENT("https://graph.windows.net/","https://login.microsoftonline.us");

    private final String graphEndpoint;
    private final String authorityEndpoint;

    DefaultRegion(String graphEndpoint, String authorityEndpoint) {
        this.graphEndpoint = graphEndpoint;
        this.authorityEndpoint = authorityEndpoint;
    }

    public String getGraphApiUrl() {
        return graphEndpoint;
    }

    /**
     * Returns basic Authority API URL, which is not specific to any tenant
     * @return Authority API URl
     */
    public String getBasicAuthorityApiUrl() {
        return authorityEndpoint;
    }

}
