package com.atlassian.crowd.directory.rest.endpoint;

import javax.ws.rs.core.UriBuilder;

/**
 * Represents resolvers for Azure Ad directories with custom endpoints specified
 */
public class CustomAzureApiUriResolver implements AzureApiUriResolver {
    private final String graphApi;
    private final String authorityApi;

    public CustomAzureApiUriResolver(String graphApi, String authorityApi) {
        this.graphApi = graphApi;
        this.authorityApi = authorityApi;
    }

    @Override
    public String getGraphApiUrl() {
        return graphApi;
    }

    @Override
    public String getAuthorityApiUrl(String tenantId) {
        return UriBuilder.fromUri(authorityApi).path(tenantId).build().toString();
    }
}
