package com.atlassian.crowd.directory.rest.endpoint;

import javax.ws.rs.core.UriBuilder;

/**
 * Represents resolvers for Azure Ad directories with default endpoints
 */
public class BasicAzureApiUriResolver implements AzureApiUriResolver {
    private final DefaultRegion region;

    public BasicAzureApiUriResolver(DefaultRegion region) {
        this.region = region;
    }

    @Override
    public String getGraphApiUrl() {
        return region.getGraphApiUrl();
    }

    @Override
    public String getAuthorityApiUrl(String tenantId) {
        return UriBuilder.fromUri(region.getBasicAuthorityApiUrl()).path(tenantId).build().toString();
    }
}
