package com.atlassian.crowd.directory.rest.endpoint;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class AzureApiUriResolverFactory {

    public AzureApiUriResolver getEndpointDataProviderForDirectory(AzureAdDirectory azureAdDirectory) {
        final String region = Strings.nullToEmpty(azureAdDirectory.getValue(AzureAdDirectory.REGION_ATTRIBUTE));
        final Optional<DefaultRegion> knownRegion = Enums.getIfPresent(DefaultRegion.class, region);
        if (knownRegion.isPresent()) {
            return new BasicAzureApiUriResolver(knownRegion.get());
        } else if (AzureAdDirectory.CUSTOM_REGION_ATTRIBUTE_VALUE.equals(region)) {
            final String graphApiUrl = Preconditions.checkNotNull(azureAdDirectory.getValue(AzureAdDirectory.GRAPH_API_ENDPOINT_ATTRIBUTE));
            final String authorityApiUrl = Preconditions.checkNotNull(azureAdDirectory.getValue(AzureAdDirectory.AUTHORITY_API_ENDPOINT_ATTRIBUTE));
            return new CustomAzureApiUriResolver(graphApiUrl, authorityApiUrl);
        } else {
            throw new IllegalArgumentException(String.format("The directory %s doesn't have the expected %s attribute", azureAdDirectory.getDirectoryId(), AzureAdDirectory.REGION_ATTRIBUTE));
        }
    }
}