package com.atlassian.crowd.directory.rest.endpoint;

/**
 * Provides addresses of Azure AD APIs
 * @since 3.2.0
 */
public interface AzureApiUriResolver {

    /**
     * @return The Graph API URL
     */
    String getGraphApiUrl();

    /**
     * Gives Authority API URL for given tenant
     * @param tenantId the tenant id
     * @return Authority API URL
     */
    String getAuthorityApiUrl(String tenantId);

    default String getScopeUrl() {
        return getGraphApiUrl() + "/.default";
    }


}
