package com.atlassian.crowd.directory.rest.delta;

import java.util.List;

/**
 * Represents a mapped result from a Graph delta query. In addition to the results theirselves, a link for tracking
 * changes is present
 * @param <T> the type of the results
 */
public class GraphDeltaQueryResult<T> {

    private final List<T> results;
    private final String deltaLink;

    public GraphDeltaQueryResult(List<T> results, String deltaLink) {
        this.results = results;
        this.deltaLink = deltaLink;
    }

    public List<T> getResults() {
        return results;
    }

    public String getDeltaLink() {
        return deltaLink;
    }
}
