package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;

/**
 * Creates an {@link AzureAdRestClient} and all of its dependencies, using the given Azure application data.
 */
public interface AzureAdRestClientFactory {

    /**
     * @param clientId Client ID of the web application used to communicate with Azure
     * @param clientSecret Client secret of the web application used to communicate with Azure
     * @param tenantId ID or name of the Azure tenant to use
     * @param endpointDataProvider Endpoint data provider appropriate for tenant's region
     * @param connectionTimeout The connection timeout to use when communicating with Azure AD
     * @param readTimeout The read timeout to use when communicating with Azure AD
     * @return an instance of {@link AzureAdRestClient}, configured to use the specified parameters
     */
    AzureAdRestClient create(final String clientId, final String clientSecret, final String tenantId, final AzureApiUriResolver endpointDataProvider, final long connectionTimeout, final long readTimeout);

    /**
     * @param restClient the REST client which should be wrapped by the paging wrapper
     * @return a wrapper class for paging Azure AD results
     */
    default AzureAdPagingWrapper create(final AzureAdRestClient restClient) {
        return new AzureAdPagingWrapper(restClient);
    }
}
