package com.atlassian.crowd.directory.query;

import java.util.Objects;


/**
 * Represents a $filter query parameter used by Microsoft Graph. Used to filter the returned results.
 * See: http://docs.oasis-open.org/odata/odata/v4.0/errata03/os/complete/part2-url-conventions/odata-v4.0-errata03-os-part2-url-conventions-complete.html
 */
public class ODataFilter implements MicrosoftGraphQueryParam {

    public static final String QUERY_PARAM_NAME = "$filter";
    private final String value;

    public static final ODataFilter EMPTY = new ODataFilter("");

    public ODataFilter(final String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return QUERY_PARAM_NAME;
    }

    public String asRawValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ODataFilter that = (ODataFilter) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
