package com.atlassian.crowd.directory.query;

import java.util.Objects;

/**
 * Represents an $expand query parameter used by Microsoft Graph. Used to specify which navigational properties should be included with the result.
 * See: http://docs.oasis-open.org/odata/odata/v4.0/errata03/os/complete/part2-url-conventions/odata-v4.0-errata03-os-part2-url-conventions-complete.html
 */
public class ODataExpand implements MicrosoftGraphQueryParam {

    public static final String QUERY_PARAM_NAME = "$expand";
    private final String value;

    public ODataExpand(String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return QUERY_PARAM_NAME;
    }

    @Override
    public String asRawValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ODataExpand that = (ODataExpand) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
