package com.atlassian.crowd.directory.query;

import com.google.common.base.Charsets;
import com.sun.jersey.core.util.StringKeyStringValueIgnoreCaseMultivaluedMap;

import javax.ws.rs.core.MultivaluedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;

public final class MicrosoftGraphQueryParams {

    private MicrosoftGraphQueryParams() {}

    /**
     * @return the encoded value of the underlying query parameter ready to be used in a Graph query
     * @param microsoftGraphQueryParam
     */
    public static String asEncodedQueryParam(MicrosoftGraphQueryParam microsoftGraphQueryParam) {
        try {
            return URLEncoder.encode(microsoftGraphQueryParam.asRawValue(), Charsets.UTF_8.name());
        } catch (final UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @return a MultiValuedMap for use in {@link com.sun.jersey.api.client.WebResource#queryParams(MultivaluedMap)}
     * @param microsoftGraphQueryParam
     */
    public static MultivaluedMap<String, String> asQueryParams(MicrosoftGraphQueryParam... microsoftGraphQueryParam) {
        final StringKeyStringValueIgnoreCaseMultivaluedMap map = new StringKeyStringValueIgnoreCaseMultivaluedMap();
        Arrays.stream(microsoftGraphQueryParam).forEach(param -> map.add(param.getName(), param.asRawValue()));
        return map;
    }
}
