package com.atlassian.crowd.directory.query;

import java.util.Objects;

/**
 * Represents a token used for change tracking with an Azure AD delta query.
 */
public class MicrosoftGraphDeltaToken implements MicrosoftGraphQueryParam {

    public static final String QUERY_PARAM_NAME = "$deltatoken";
    private final String value;

    public MicrosoftGraphDeltaToken(String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return QUERY_PARAM_NAME;
    }

    @Override
    public String asRawValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MicrosoftGraphDeltaToken that = (MicrosoftGraphDeltaToken) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
