package com.atlassian.crowd.directory.query;

import java.util.Objects;

/**
 * Represents a query to the Microsoft Graph API. Contains the filter, the columns to retrieve, the start index and the
 * max results
 */
public class GraphQuery {

    private final ODataFilter filter;
    private final ODataSelect select;
    private final ODataTop limit;
    private final int startIndex;

    public GraphQuery(final ODataFilter filter, final ODataSelect select,
                      final int startIndex, final ODataTop limit) {
        this.filter = filter;
        this.select = select;
        this.startIndex = startIndex;
        this.limit = limit;
    }

    public ODataFilter getFilter() {
        return filter;
    }

    public ODataSelect getSelect() {
        return select;
    }

    public ODataTop getLimit() {
        return limit;
    }

    public int getStartIndex() {
        return startIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GraphQuery that = (GraphQuery) o;
        return Objects.equals(limit, that.limit) &&
                startIndex == that.startIndex &&
                Objects.equals(filter, that.filter) &&
                Objects.equals(select, that.select);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filter, select, limit, startIndex);
    }
}
