package com.atlassian.crowd.directory.query;

/**
 * Specifies the properties that should be fetched from Azure Active Directory
 */
public enum FetchMode {

    /**
     * Will fetch all properties that are mapped to Crowd. Memberships will not be fetched
     */
    FULL,

    /**
     * Will fetch all properties that are mapped to Crowd. Memberships for groups will be fetched. Only applicable to
     * delta queries
     */
    DELTA_QUERY,

    /**
     * Will fetch the entity name and external id
     */
    NAME_AND_ID,

    /**
     * Will only fetch the entity name
     */
    NAME,

    /**
     * Will only fetch the external id
     */
    ID,
}
